/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.Task;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.SessionQueryResult;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.task.SQLRTTask;
import com.aliyun.odps.utils.CSVRecordParser;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Session {
    private static final String DEFAULT_TASK_NAME = "console_sqlrt_task";
    private static final long POLL_INTERVAL = TimeUnit.MILLISECONDS.toMillis(1000L);
    private static final Long SESSION_TIMEOUT = 60L;
    private String taskName = "console_sqlrt_task";
    private String token;
    private long tokenExpiredHours = 168L;
    private Odps odps;
    private String sessionName;
    private Instance instance;
    private String logView;
    private boolean isStarted = false;
    private SessionProgress progress = null;
    private String startSessionMessage;
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    public static int OBJECT_STATUS_RUNNING = 2;
    public static int OBJECT_STATUS_FAILED = 4;
    public static int OBJECT_STATUS_TERMINATED = 5;
    public static int OBJECT_STATUS_CANCELLED = 6;

    public Session(Odps odps, Instance instance) {
        this(odps, instance, null, DEFAULT_TASK_NAME);
    }

    public Session(Odps odps, Instance instance, String sessionName, String taskName) {
        this.sessionName = sessionName;
        this.instance = instance;
        this.startSessionMessage = "";
        this.taskName = taskName;
        this.odps = odps;
    }

    public String getLogView() throws OdpsException {
        if (this.logView == null && this.odps != null) {
            this.logView = new LogView(this.odps).generateLogView(this.instance, 168L);
        }
        return this.logView;
    }

    public void setLogView(String logView) {
        this.logView = logView;
    }

    public String getStartSessionMessage() {
        return this.startSessionMessage;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static Session attach(Odps odps, String sessionName) throws OdpsException {
        return Session.attach(odps, sessionName, null);
    }

    public static Session attach(Odps odps, String sessionName, Map<String, String> hints) throws OdpsException {
        return Session.attach(odps, sessionName, hints, null);
    }

    public static Session attach(Odps odps, String sessionName, Map<String, String> hints, Long timeout) throws OdpsException {
        return Session.attach(odps, sessionName, hints, timeout, DEFAULT_TASK_NAME);
    }

    public static Session attach(Odps odps, String sessionName, Map<String, String> hints, Long timeout, String taskName) throws OdpsException {
        return Session.attach(odps, sessionName, hints, timeout, null, taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session attach(Odps odps, String sessionName, Map<String, String> hints, Long timeout, String runningCluster, String taskName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)sessionName)) {
            throw new IllegalArgumentException("Session name can not be empty.");
        }
        if (hints == null) {
            hints = new HashMap<String, String>();
        }
        hints.put("odps.sql.session.share.id", sessionName);
        try {
            Session session = Session.createInternal(odps, null, sessionName, null, null, null, hints, timeout, null, runningCluster, taskName);
            return session;
        }
        finally {
            hints.remove("odps.sql.session.share.id");
        }
    }

    public static Session create(Odps odps, int workerCount, int workerMemory) throws OdpsException {
        return Session.create(odps, workerCount, workerMemory, null, null, null, null, null);
    }

    public static Session create(Odps odps, int workerCount, int workerMemory, String sessionName) throws OdpsException {
        return Session.create(odps, workerCount, workerMemory, sessionName, null, null, null, null);
    }

    public static Session create(Odps odps, int workerCount, int workerMemory, String sessionName, String projectName, String workerSpareSpan, Map<String, String> hints, Long timeout) throws OdpsException {
        return Session.create(odps, workerCount, workerMemory, sessionName, projectName, workerSpareSpan, hints, timeout, null);
    }

    public static Session create(Odps odps, int workerCount, int workerMemory, String sessionName, String projectName, String workerSpareSpan, Map<String, String> hints, Long timeout, Integer priority) throws OdpsException {
        return Session.create(odps, workerCount, workerMemory, sessionName, projectName, workerSpareSpan, hints, timeout, priority, null);
    }

    public static Session create(Odps odps, int workerCount, int workerMemory, String sessionName, String projectName, String workerSpareSpan, Map<String, String> hints, Long timeout, Integer priority, String runningCluster) throws OdpsException {
        return Session.createInternal(odps, projectName, sessionName, workerCount, workerMemory, workerSpareSpan, hints, timeout, priority, runningCluster);
    }

    public static Session create(Odps odps, int workerCount, int workerMemory, String sessionName, String projectName, String workerSpareSpan, Map<String, String> hints, Long timeout, Integer priority, String runningCluster, String taskName) throws OdpsException {
        return Session.createInternal(odps, projectName, sessionName, workerCount, workerMemory, workerSpareSpan, hints, timeout, priority, runningCluster, taskName);
    }

    public static Session create(Odps odps, String sessionName, String projectName, Map<String, String> hints, Long timeout) throws OdpsException {
        return Session.create(odps, sessionName, projectName, hints, timeout, null);
    }

    public static Session create(Odps odps, String sessionName, String projectName, Map<String, String> hints, Long timeout, Integer priority) throws OdpsException {
        return Session.create(odps, sessionName, projectName, hints, timeout, priority, null);
    }

    public static Session create(Odps odps, String sessionName, String projectName, Map<String, String> hints, Long timeout, Integer priority, String runningCluster) throws OdpsException {
        return Session.createInternal(odps, projectName, sessionName, null, null, null, hints, timeout, priority, runningCluster);
    }

    @Deprecated
    public SessionQueryResult run(String sql) throws OdpsException {
        return this.run(sql, null);
    }

    @Deprecated
    public SessionQueryResult run(String sql, Map<String, String> hints) throws OdpsException {
        JsonObject request = new JsonObject();
        request.add("query", (JsonElement)new JsonPrimitive(sql));
        if (hints == null) {
            hints = new HashMap<String, String>();
        }
        JsonObject settings = new JsonObject();
        for (Map.Entry<String, String> property : hints.entrySet()) {
            settings.addProperty(property.getKey(), property.getValue());
        }
        request.add("settings", (JsonElement)settings);
        Instance.SetInformationResult setInformationResult = this.instance.setInformation(this.taskName, "query", gson.toJson((JsonElement)request));
        SubQueryInfo subQueryInfo = null;
        if (!setInformationResult.status.equals("ok")) {
            subQueryInfo = new SubQueryInfo(setInformationResult.status, setInformationResult.result);
        } else if (!StringUtils.isNullOrEmpty((String)setInformationResult.result)) {
            Type type = new TypeToken<SubQueryInfo>(){}.getType();
            try {
                subQueryInfo = (SubQueryInfo)gson.fromJson(setInformationResult.result, type);
            }
            catch (Exception e) {
                throw new OdpsException(setInformationResult.result);
            }
            subQueryInfo.status = setInformationResult.status;
        }
        return new SessionQueryResult(subQueryInfo, (Iterator<SubQueryResponse>)new ListIterator<SubQueryResponse>(){
            boolean queryTerminated = false;

            @Override
            protected List<SubQueryResponse> list() {
                try {
                    SubQueryResponse response;
                    if (this.queryTerminated) {
                        return null;
                    }
                    while ((response = Session.this.getResponse(Session.this.instance.getTaskInfo(Session.this.taskName, "result"))) == null || response.status == null) {
                        Session.this.checkTaskStatus();
                    }
                    if (response.status != OBJECT_STATUS_RUNNING) {
                        this.queryTerminated = true;
                    }
                    return Arrays.asList(response);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        });
    }

    public SubQueryInfo runSubQuery(String sql, Map<String, String> hints) throws OdpsException {
        JsonObject request = new JsonObject();
        request.add("query", (JsonElement)new JsonPrimitive(sql));
        if (hints == null) {
            hints = new HashMap<String, String>();
        }
        JsonObject settings = new JsonObject();
        for (Map.Entry<String, String> property : hints.entrySet()) {
            settings.addProperty(property.getKey(), property.getValue());
        }
        request.add("settings", (JsonElement)settings);
        Instance.SetInformationResult setInformationResult = this.instance.setInformation(this.taskName, "query", gson.toJson((JsonElement)request));
        SubQueryInfo subQueryInfo = null;
        if (!setInformationResult.status.equals("ok")) {
            subQueryInfo = new SubQueryInfo(setInformationResult.status, setInformationResult.result);
        } else if (!StringUtils.isNullOrEmpty((String)setInformationResult.result)) {
            Type type = new TypeToken<SubQueryInfo>(){}.getType();
            try {
                subQueryInfo = (SubQueryInfo)gson.fromJson(setInformationResult.result, type);
            }
            catch (Exception e) {
                throw new OdpsException(setInformationResult.result);
            }
            subQueryInfo.status = setInformationResult.status;
        } else {
            throw new OdpsException("Invalid setInformation response.");
        }
        return subQueryInfo;
    }

    public SubQueryResponse waitForSubqueryTerminated(int queryId) throws OdpsException {
        boolean terminated = false;
        SubQueryResponse response = new SubQueryResponse();
        while (!terminated) {
            response = this.getResponse(this.instance.getTaskInfo(this.taskName, "get_finished_status_" + queryId));
            if (response == null || response.status == null) {
                this.checkTaskStatus();
                continue;
            }
            if (response.status == OBJECT_STATUS_FAILED && response.result.contains("SubQuery not found")) {
                throw new OdpsException(response.result);
            }
            if (response.status == OBJECT_STATUS_RUNNING) continue;
            terminated = true;
        }
        return response;
    }

    public SubQueryResult getSubQueryResult(int queryId) throws OdpsException {
        String resultString = this.getSubQueryResultInternal(queryId);
        SubQueryResult result = new SubQueryResult();
        CSVRecordParser.ParseResult parseResult = CSVRecordParser.parse(resultString);
        result.setSchema(parseResult.getSchema());
        result.setRecords(parseResult.getRecords());
        return result;
    }

    public SubQueryResult getRawSubQueryResult(int queryId) throws OdpsException {
        String resultString = this.getSubQueryResultInternal(queryId);
        SubQueryResult result = new SubQueryResult();
        List<Record> records = CommandUtil.toRecord(resultString, "Info");
        TableSchema schema = new TableSchema();
        schema.setColumns(Arrays.asList(records.get(0).getColumns()));
        result.setSchema(schema);
        result.setRecords(records);
        return result;
    }

    public SubQueryResult getSubQueryResultFromWorker(int queryId) throws OdpsException {
        SubQueryResponse response = this.waitForSubqueryTerminated(queryId);
        String subqueryId = "session_query_" + queryId;
        String resultString = this.instance.getRawSubqueryResults(subqueryId, this.taskName);
        if (response.status == OBJECT_STATUS_FAILED) {
            throw new OdpsException(resultString);
        }
        if (!StringUtils.isNullOrEmpty((String)response.result)) {
            resultString = resultString + response.result;
        }
        SubQueryResult result = new SubQueryResult();
        if (!StringUtils.isNullOrEmpty((String)response.warnings)) {
            result.addWarning(response.warnings);
        }
        CSVRecordParser.ParseResult parseResult = CSVRecordParser.parse(resultString);
        result.setSchema(parseResult.getSchema());
        result.setRecords(parseResult.getRecords());
        return result;
    }

    public List<String> showVariables(Map<String, String> hints) throws OdpsException {
        SubQueryInfo subQueryInfo = this.runSubQuery("show variables;", hints);
        String resultString = this.getSubQueryResultInternal(subQueryInfo.queryId);
        List<String> vars = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty((String)resultString)) {
            vars = Arrays.asList(resultString.split("\n"));
        }
        return vars;
    }

    private String getSubQueryResultInternal(int queryId) throws OdpsException {
        SubQueryResult result = new SubQueryResult();
        String resultString = "";
        boolean terminated = false;
        while (!terminated) {
            SubQueryResponse response = this.getResponse(this.instance.getTaskInfo(this.taskName, "result_" + queryId));
            if (response == null || response.status == null) {
                this.checkTaskStatus();
                continue;
            }
            if (!StringUtils.isNullOrEmpty((String)response.result)) {
                resultString = resultString + response.result;
            }
            if (!StringUtils.isNullOrEmpty((String)response.warnings)) {
                result.addWarning(response.warnings);
            }
            if (response.status == OBJECT_STATUS_FAILED) {
                throw new OdpsException(resultString);
            }
            if (response.status == OBJECT_STATUS_RUNNING) continue;
            terminated = true;
        }
        return resultString;
    }

    public void stop() throws OdpsException {
        this.instance.stop();
    }

    public void waitForStart() throws OdpsException {
        this.waitForStart(0L);
    }

    public boolean isStarted() throws OdpsException {
        if (!this.isStarted) {
            SubQueryResponse response = this.getResponse(this.instance.getTaskInfo(this.taskName, "status"));
            if (response == null || response.status == null) {
                this.checkTaskStatus();
            } else if (response.status == OBJECT_STATUS_RUNNING) {
                this.isStarted = true;
                if (response.result != null && response.result.length() > 0) {
                    this.startSessionMessage = this.startSessionMessage + response.result;
                }
            } else {
                if (response.status == OBJECT_STATUS_FAILED) {
                    throw new OdpsException(String.format("Start session[%s] failed: %s ", this.instance.getId(), response.result));
                }
                if (!StringUtils.isNullOrEmpty((String)response.result)) {
                    try {
                        this.progress = (SessionProgress)gson.fromJson(response.result, SessionProgress.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this.isStarted;
    }

    public void waitAttachSuccess(long timeout) throws OdpsException {
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        if (timeout > 0L) {
            endTime += startTime + TimeUnit.SECONDS.toMillis(timeout);
        }
        while (0L == endTime || System.currentTimeMillis() < endTime) {
            SubQueryResponse response = this.getResponse(this.instance.getTaskInfo(this.taskName, "wait_attach_success"));
            if (response == null || response.status == null) {
                this.checkTaskStatus();
                continue;
            }
            if (response.status == OBJECT_STATUS_RUNNING) {
                if (response.result != null && response.result.length() > 0) {
                    this.startSessionMessage = this.startSessionMessage + response.result;
                }
                return;
            }
            if (response.status != OBJECT_STATUS_FAILED && response.status != OBJECT_STATUS_TERMINATED) continue;
            throw new OdpsException(String.format("Attach session[%s] failed: %s ", this.instance.getId(), response.result));
        }
        this.instance.stop();
        throw new OdpsException("Attach session[%s] timeout.", this.instance.getId());
    }

    public String getToken() throws OdpsException {
        if (this.token == null && this.odps != null) {
            this.token = new LogView(this.odps).generateInstanceToken(this.instance, this.tokenExpiredHours);
        }
        return this.token;
    }

    public String getQueryStats() throws OdpsException {
        return this.getInformation("sqlstats");
    }

    public String getQueryStats(int queryId) throws OdpsException {
        return this.getInformation("sqlstats_" + String.valueOf(queryId));
    }

    public String getInformation(String key) throws OdpsException {
        SubQueryResponse response = this.getResponse(this.instance.getTaskInfo(this.taskName, key));
        if (response != null && response.result != null) {
            return response.result;
        }
        return null;
    }

    public String setInformation(String key, String value) throws OdpsException {
        String result = this.instance.setTaskInfo(this.taskName, key, value);
        return result;
    }

    public SessionProgress getStartProgress() throws OdpsException {
        if (this.progress == null) {
            this.isStarted();
        }
        return this.progress;
    }

    public void waitForStart(long timeout) throws OdpsException {
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        if (timeout > 0L) {
            endTime += startTime + TimeUnit.SECONDS.toMillis(timeout);
        }
        while (0L == endTime || System.currentTimeMillis() < endTime) {
            if (this.isStarted()) {
                return;
            }
            this.sleep();
        }
        throw new OdpsException("Start session[%s] timeout.", this.instance.getId());
    }

    private SubQueryResponse getResponse(String result) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)result)) {
            return null;
        }
        try {
            return (SubQueryResponse)gson.fromJson(result, SubQueryResponse.class);
        }
        catch (Exception e) {
            throw new OdpsException("Invalid response:" + result);
        }
    }

    private void checkTaskStatus() throws OdpsException {
        Instance.TaskStatus status = this.instance.getTaskStatus().get(this.taskName);
        if (status != null && status.getStatus() != Instance.TaskStatus.Status.RUNNING) {
            throw new OdpsException(String.format("Session[%s] is %s: %s", this.instance.getId(), status.getStatus().toString(), this.instance.getTaskResults().get(this.taskName)));
        }
    }

    private static Session createInternal(Odps odps, String projectName, String sessionName, Integer workerCount, Integer workerMemory, String workerSpareSpan, Map<String, String> hints, Long timeout, Integer priority, String runningCluster) throws OdpsException {
        return Session.createInternal(odps, projectName, sessionName, workerCount, workerMemory, workerSpareSpan, hints, timeout, priority, runningCluster, DEFAULT_TASK_NAME);
    }

    private static Session createInternal(Odps odps, String projectName, String sessionName, Integer workerCount, Integer workerMemory, String workerSpareSpan, Map<String, String> hints, Long timeout, Integer priority, String runningCluster, String taskName) throws OdpsException {
        if (projectName != null && projectName.trim().isEmpty()) {
            throw new IllegalArgumentException("Project name can not be empty.");
        }
        if (null == hints) {
            hints = new HashMap<String, String>();
        }
        String string = projectName = projectName == null ? odps.getDefaultProject() : projectName;
        if (!StringUtils.isNullOrEmpty((String)workerSpareSpan)) {
            hints.put("odps.sql.session.worker.sparespan", workerSpareSpan);
        }
        if (!StringUtils.isNullOrEmpty((String)sessionName)) {
            hints.put("odps.sql.session.name", sessionName.trim());
        }
        if (null != workerCount) {
            hints.put("odps.sql.session.worker.count", workerCount.toString());
        }
        if (null != workerMemory) {
            hints.put("odps.sql.session.worker.memory", workerMemory.toString());
        }
        String userSubmitMode = hints.get("odps.sql.submit.mode");
        hints.put("odps.sql.submit.mode", "script");
        SQLRTTask task = new SQLRTTask();
        task.setName(taskName);
        try {
            String json = gson.toJson(hints);
            task.setProperty("settings", json);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        if (userSubmitMode == null || userSubmitMode.isEmpty()) {
            hints.remove("odps.sql.submit.mode");
        } else {
            hints.put("odps.sql.submit.mode", userSubmitMode);
        }
        Instance instance = odps.instances().create(projectName, (Task)task, priority, runningCluster);
        Session session = new Session(odps, instance, sessionName, taskName);
        if (hints.containsKey("odps.sql.session.share.id")) {
            if (timeout != null) {
                session.waitAttachSuccess(timeout);
            } else {
                session.waitAttachSuccess(SESSION_TIMEOUT);
            }
        } else if (timeout != null) {
            session.waitForStart(timeout);
        }
        return session;
    }

    public void printLogView() throws OdpsException {
        System.out.println("");
        System.err.println("ID = " + this.instance.getId());
        System.err.println("Log view:");
        System.err.println(this.getLogView());
    }

    public void cancelQuery(int queryId) throws OdpsException {
        Instance.SetInformationResult setInformationResult = this.instance.setInformation(this.taskName, "cancel", String.valueOf(queryId));
        if (!setInformationResult.status.equals("ok")) {
            throw new OdpsException(setInformationResult.result);
        }
    }

    private void sleep() throws OdpsException {
        try {
            Thread.sleep(POLL_INTERVAL);
        }
        catch (InterruptedException e) {
            throw new OdpsException("Interrupted while sleep.", e);
        }
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public class SessionProgress {
        public Integer totalWorkerCount;
        public Integer launchedWorkerCount;
        public Integer launchedPercentage;
    }

    public class SubQueryResponse {
        public Integer status;
        public String result;
        public String warnings;
        public Integer subQueryId;
    }

    public class SessionItem {
        public String owner;
        public String sessionId;
        public String aliasName;
        public String version;
    }

    public class SubQueryResult {
        TableSchema schema = null;
        List<String> warnings = new ArrayList<String>();
        List<Record> records = null;

        public void setSchema(TableSchema schema) {
            this.schema = schema;
        }

        public void addWarning(String warning) {
            this.warnings.add(warning);
        }

        public void setRecords(List<Record> records) {
            this.records = records;
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public List<Record> getRecords() {
            return this.records;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }
    }

    public class SubQueryInfo {
        public static final String kNotFoundCode = "NotFound";
        public static final String kFailedCode = "Failed";
        public static final String kOKCode = "ok";
        public int queryId = -1;
        public String status = "ok";
        public String result;

        public SubQueryInfo(String status, String result) {
            this.status = status;
            this.result = result;
        }
    }
}

