/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Function;
import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Schema;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Schemas
implements Iterable<Schema> {
    private RestClient client;
    private Odps odps;

    Schemas(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public boolean exists(String schemaName) {
        return this.exists(this.odps.getDefaultProject(), schemaName);
    }

    public boolean exists(String projectName, String schemaName) {
        try {
            Iterator<Function> iter = this.odps.functions().iterator(projectName, schemaName);
            iter.hasNext();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public Iterator<Schema> iterator() {
        return this.iterator(this.odps.getDefaultProject());
    }

    public Iterator<Schema> iterator(String projectName) {
        return new SchemaListIterator(projectName);
    }

    public Iterable<Schema> iterable() {
        return this.iterable(this.odps.getDefaultProject());
    }

    public Iterable<Schema> iterable(String projectName) {
        return () -> new SchemaListIterator(projectName);
    }

    private class SchemaListIterator
    extends ListIterator<Schema> {
        String projectName;
        boolean hasList = false;

        public SchemaListIterator(String projectName) {
            if (StringUtils.isNullOrEmpty((String)projectName)) {
                throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
            }
            this.projectName = projectName;
        }

        @Override
        protected List<Schema> list() {
            if (this.hasList) {
                return null;
            }
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            try {
                String[] schemaNames;
                Instance i = SQLTask.run(Schemas.this.odps, "show schemas in " + this.projectName + ";");
                i.waitForSuccess();
                for (String name : schemaNames = i.getTaskResults().get("AnonymousSQLTask").split("\n")) {
                    schemas.add(new Schema(name));
                }
            }
            catch (OdpsException e) {
                return null;
            }
            this.hasList = true;
            return schemas;
        }
    }
}

