/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.volume.FSDataInputStream;
import com.aliyun.odps.volume.FSDataOutputStream;
import com.aliyun.odps.volume.FileStatus;
import com.aliyun.odps.volume.Path;
import com.aliyun.odps.volume.PathFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public abstract class FileSystem {
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }
    };

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public abstract FSDataInputStream open(Path var1) throws IOException;

    public FSDataOutputStream create(Path f) throws IOException {
        return this.create(f, true);
    }

    public abstract FSDataOutputStream create(Path var1, boolean var2) throws IOException;

    public abstract FSDataOutputStream create(Path var1, boolean var2, int var3) throws IOException;

    public boolean createNewFile(Path f) throws IOException {
        if (this.exists(f)) {
            return false;
        }
        this.create(f, false).close();
        return true;
    }

    public abstract FSDataOutputStream append(Path var1) throws IOException;

    public abstract FSDataOutputStream append(Path var1, int var2) throws IOException;

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    public abstract boolean delete(Path var1) throws IOException;

    public boolean delete(Path f, boolean recursive) throws IOException {
        if (!recursive) {
            throw new RuntimeException("Non-recursive delete not implemented...");
        }
        return this.delete(f);
    }

    public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isDirectory(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public abstract FileStatus[] listStatus(Path var1) throws FileNotFoundException, IOException;

    private void listStatus(ArrayList<FileStatus> results, Path f, PathFilter filter) throws FileNotFoundException, IOException {
        FileStatus[] listing = this.listStatus(f);
        if (listing == null) {
            throw new IOException("Error accessing " + f);
        }
        for (int i = 0; i < listing.length; ++i) {
            if (!filter.accept(listing[i].getPath())) continue;
            results.add(listing[i]);
        }
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        this.listStatus(results, f, filter);
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] listStatus(Path[] files) throws FileNotFoundException, IOException {
        return this.listStatus(files, DEFAULT_FILTER);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws FileNotFoundException, IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (int i = 0; i < files.length; ++i) {
            this.listStatus(results, files[i], filter);
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public abstract boolean mkdirs(Path var1) throws IOException;

    public abstract FileStatus getFileStatus(Path var1) throws IOException;
}

