/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

public class IntervalYearMonth
implements Comparable<IntervalYearMonth> {
    private static final int MONTHS_PER_YEAR = 12;
    private static final int MAX_YEARS = 9999;
    protected int totalMonths;

    public IntervalYearMonth(int years, int months) {
        if (Math.abs(this.totalMonths) / 12 > 9999) {
            throw new IllegalArgumentException(Integer.toString(years));
        }
        if (Math.abs(months) >= 12) {
            throw new IllegalArgumentException(Integer.toString(months));
        }
        this.totalMonths = years * 12 + months;
    }

    public IntervalYearMonth(int totalMonths) {
        if (Math.abs(totalMonths) / 12 > 9999) {
            throw new IllegalArgumentException(Integer.toString(totalMonths));
        }
        this.totalMonths = totalMonths;
    }

    public int getTotalMonths() {
        return this.totalMonths;
    }

    public int getYears() {
        return this.totalMonths / 12;
    }

    public int getMonths() {
        return this.totalMonths % 12;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.totalMonths < 0) {
            buf.append('-');
        }
        buf.append(Math.abs(this.getYears())).append('-').append(Math.abs(this.getMonths()));
        return buf.toString();
    }

    @Override
    public int compareTo(IntervalYearMonth o) {
        return this.totalMonths - o.totalMonths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalYearMonth that = (IntervalYearMonth)o;
        return this.totalMonths == that.totalMonths;
    }

    public int hashCode() {
        return this.totalMonths;
    }
}

