/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayRecord
implements Record {
    private static final int STRING_MAX_LENTH = 0x800000;
    private static final int DECIMAL_MAX_INTLENGTH = 36;
    private static final int DECIMAL_MAX_SCALE = 18;
    private static final long DATETIME_MAX_TICKS = 253402271999000L;
    private static final long DATETIME_MIN_TICKS = -62135798400000L;
    private Column[] columns;
    private final Object[] values;
    private static final String STRING_CHARSET = "UTF-8";
    private HashMap<String, Integer> nameMap = new HashMap();

    public ArrayRecord(Column[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.nameMap.put(columns[i].getName(), i);
        }
    }

    public ArrayRecord(TableSchema schema) {
        this(schema.getColumns().toArray(new Column[0]));
    }

    @Override
    public int getColumnCount() {
        return this.values.length;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public void set(int idx, Object value) {
        switch (this.columns[idx].getType()) {
            case STRING: {
                if (value instanceof String) {
                    this.setString(idx, (String)value);
                    break;
                }
                this.setString(idx, (byte[])value);
                break;
            }
            case BIGINT: {
                this.setBigint(idx, (Long)value);
                break;
            }
            case BOOLEAN: {
                this.setBoolean(idx, (Boolean)value);
                break;
            }
            case DOUBLE: {
                this.setDouble(idx, (Double)value);
                break;
            }
            case DATETIME: {
                this.setDatetime(idx, (Date)value);
                break;
            }
            case DECIMAL: {
                this.setDecimal(idx, (BigDecimal)value);
                break;
            }
            case ARRAY: {
                this.setArray(idx, (List)value);
                break;
            }
            case MAP: {
                this.setMap(idx, (Map)value);
            }
        }
    }

    @Override
    public Object get(int idx) {
        return this.values[idx];
    }

    @Override
    public void set(String columnName, Object value) {
        this.set(this.getColumnIndex(columnName), value);
    }

    @Override
    public Object get(String columnName) {
        return this.values[this.getColumnIndex(columnName)];
    }

    @Override
    public void setBigint(int idx, Long value) {
        if (value != null && (value > Long.MAX_VALUE || value <= Long.MIN_VALUE)) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
        this.values[idx] = value;
    }

    @Override
    public Long getBigint(int idx) {
        return (Long)this.get(idx);
    }

    @Override
    public void setBigint(String columnName, Long value) {
        this.setBigint(this.getColumnIndex(columnName), value);
    }

    @Override
    public Long getBigint(String columnName) {
        return (Long)this.get(columnName);
    }

    @Override
    public void setDouble(int idx, Double value) {
        this.values[idx] = value;
    }

    @Override
    public Double getDouble(int idx) {
        return (Double)this.get(idx);
    }

    @Override
    public void setDouble(String columnName, Double value) {
        this.setDouble(this.getColumnIndex(columnName), value);
    }

    @Override
    public Double getDouble(String columnName) {
        return (Double)this.get(columnName);
    }

    @Override
    public void setBoolean(int idx, Boolean value) {
        this.values[idx] = value;
    }

    @Override
    public Boolean getBoolean(int idx) {
        return (Boolean)this.get(idx);
    }

    @Override
    public void setBoolean(String columnName, Boolean value) {
        this.setBoolean(this.getColumnIndex(columnName), value);
    }

    @Override
    public Boolean getBoolean(String columnName) {
        return (Boolean)this.get(columnName);
    }

    @Override
    public void setDatetime(int idx, Date value) {
        if (value != null && (value.getTime() > 253402271999000L || value.getTime() < -62135798400000L)) {
            throw new IllegalArgumentException("InvalidData: Datetime out of range.");
        }
        this.values[idx] = value;
    }

    @Override
    public Date getDatetime(int idx) {
        return (Date)this.get(idx);
    }

    @Override
    public void setDatetime(String columnName, Date value) {
        this.setDatetime(this.getColumnIndex(columnName), value);
    }

    @Override
    public Date getDatetime(String columnName) {
        return (Date)this.get(columnName);
    }

    @Override
    public void setDecimal(int idx, BigDecimal value) {
        BigDecimal tmpValue;
        int intLength;
        if (value != null && (intLength = (tmpValue = value.setScale(18, RoundingMode.HALF_UP)).precision() - tmpValue.scale()) > 36) {
            throw new IllegalArgumentException(String.format("decimal value %s overflow, max integer digit number is %s.", value, 36));
        }
        this.values[idx] = value;
    }

    @Override
    public BigDecimal getDecimal(int idx) {
        return (BigDecimal)this.get(idx);
    }

    @Override
    public void setDecimal(String columnName, BigDecimal value) {
        this.setDecimal(this.getColumnIndex(columnName), value);
    }

    @Override
    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.getColumnIndex(columnName));
    }

    @Override
    public void setString(int idx, String value) {
        if (value == null) {
            this.values[idx] = value;
            return;
        }
        try {
            if (value.length() * 6 > 0x800000 && value.getBytes(STRING_CHARSET).length > 0x800000) {
                throw new IllegalArgumentException("InvalidData: The string's length is more than 8M.");
            }
            this.values[idx] = value;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getString(int idx) {
        Object o = this.get(idx);
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            return this.bytesToString((byte[])o);
        }
        return (String)this.get(idx);
    }

    @Override
    public void setString(String columnName, String value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    @Override
    public String getString(String columnName) {
        return this.getString(this.getColumnIndex(columnName));
    }

    @Override
    public void setString(int idx, byte[] value) {
        if (value == null) {
            this.values[idx] = value;
            return;
        }
        if (value.length > 0x800000) {
            throw new IllegalArgumentException("InvalidData: The string's length is more than 8M.");
        }
        this.values[idx] = value;
    }

    @Override
    public void setString(String columnName, byte[] value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    @Override
    public byte[] getBytes(int idx) {
        Object o = this.get(idx);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return this.stringToBytes((String)o);
        }
        return (byte[])this.get(idx);
    }

    @Override
    public byte[] getBytes(String columnName) {
        return this.getBytes(this.getColumnIndex(columnName));
    }

    @Override
    public void set(Object[] values) {
        if (values == null || this.columns.length != values.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Override
    public Object[] toArray() {
        return this.values;
    }

    private int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    public void setArray(String columnName, List list) {
        this.setArray(this.getColumnIndex(columnName), list);
    }

    private byte[] stringToBytes(String string) {
        try {
            return String.valueOf(string).getBytes(STRING_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, STRING_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void setArray(int idx, List list) {
        if (list == null) {
            this.values[idx] = list;
            return;
        }
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            if (obj instanceof String) {
                newList.add(this.stringToBytes((String)obj));
                continue;
            }
            newList.add(obj);
        }
        this.values[idx] = newList;
    }

    public void setMap(int idx, Map map) {
        if (map == null) {
            this.values[idx] = map;
            return;
        }
        HashMap newMap = new HashMap(map.size(), 1.0f);
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof String) {
                key = this.stringToBytes((String)key);
            }
            if (value instanceof String) {
                value = this.stringToBytes((String)value);
            }
            newMap.put(key, value);
        }
        this.values[idx] = newMap;
    }

    public void setMap(String columnName, Map map) {
        this.setMap(this.getColumnIndex(columnName), map);
    }

    public <T> List<T> getArray(Class<T> className, String columnName) {
        return this.getArray(className, this.getColumnIndex(columnName));
    }

    public <T> List<T> getArray(Class<T> className, int idx) {
        List list = this.getArray(idx);
        if (list == null) {
            return null;
        }
        if (className == String.class) {
            ArrayList<String> newList = new ArrayList<String>(list.size());
            for (Object obj : list) {
                if (obj instanceof byte[]) {
                    newList.add(this.bytesToString((byte[])obj));
                    continue;
                }
                newList.add((String)obj);
            }
            return newList;
        }
        return list;
    }

    public List getArray(String columnName) {
        return this.getArray(this.getColumnIndex(columnName));
    }

    public List getArray(int idx) {
        Object obj = this.get(idx);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        throw new IllegalArgumentException("Column " + idx + " is not an array column");
    }

    public <k, v> Map<k, v> getMap(Class<k> keyClass, Class<v> valueClass, String columnName) {
        return this.getMap(keyClass, valueClass, this.getColumnIndex(columnName));
    }

    public <k, v> Map<k, v> getMap(Class<k> keyClass, Class<v> valueClass, int idx) {
        Map map = this.getMap(idx);
        if (map == null) {
            return null;
        }
        if (keyClass != String.class && valueClass != String.class) {
            return map;
        }
        HashMap newMap = new HashMap(map.size(), 1.0f);
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (keyClass == String.class && key != null) {
                key = this.bytesToString((byte[])key);
            }
            if (valueClass == String.class && value != null) {
                value = this.bytesToString((byte[])value);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    public Map getMap(String columnName) {
        return this.getMap(this.getColumnIndex(columnName));
    }

    public Map getMap(int idx) {
        Object obj = this.get(idx);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return (Map)obj;
        }
        throw new IllegalArgumentException("Column " + idx + " is not a map column");
    }
}

