/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PartitionSpec {
    private Map<String, String> kv = new LinkedHashMap<String, String>();

    public PartitionSpec() {
    }

    public PartitionSpec(String spec) {
        String[] groups;
        if (spec == null) {
            throw new IllegalArgumentException();
        }
        for (String group : groups = spec.split(",")) {
            String[] kv = group.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException("Invalid partition spec.");
            }
            String k = kv[0].trim();
            String v = kv[1].trim().replaceAll("'", "").replaceAll("\"", "");
            if (k.length() == 0 || v.length() == 0) {
                throw new IllegalArgumentException("Invalid partition spec.");
            }
            this.set(k, v);
        }
    }

    public void set(String key, String value) {
        this.kv.put(key, value);
    }

    public String get(String key) {
        return this.kv.get(key);
    }

    public Set<String> keys() {
        return this.kv.keySet();
    }

    public boolean isEmpty() {
        return this.kv.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] keys = this.keys().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append("='").append(this.get(keys[i])).append("'");
            if (i + 1 >= keys.length) continue;
            sb.append(',');
        }
        return sb.toString();
    }
}

