/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.sample;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;

public class JavaSDKPerfTest {
    private static MNSClient client = null;
    private static AtomicLong totalCount = new AtomicLong(0L);
    private static String endpoint = null;
    private static String accessId = null;
    private static String accessKey = null;
    private static String queueName = "JavaSDKPerfTestQueue";
    private static int threadNum = 100;
    private static int totalSeconds = 180;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean parseConf() {
        String confFilePath = System.getProperty("user.dir") + System.getProperty("file.separator") + "perf_test_config.properties";
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(confFilePath));
            if (bis == null) {
                System.out.println("ConfFile not opened: " + confFilePath);
                return false;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("ConfFile not found: " + confFilePath);
            return false;
        }
        Properties properties = new Properties();
        try {
            properties.load(bis);
        }
        catch (IOException e) {
            System.out.println("Load ConfFile Failed: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
        endpoint = properties.getProperty("Endpoint");
        System.out.println("Endpoint: " + endpoint);
        accessId = properties.getProperty("AccessId");
        System.out.println("AccessId: " + accessId);
        accessKey = properties.getProperty("AccessKey");
        queueName = properties.getProperty("QueueName", queueName);
        System.out.println("QueueName: " + queueName);
        threadNum = Integer.parseInt(properties.getProperty("ThreadNum", String.valueOf(threadNum)));
        System.out.println("ThreadNum: " + threadNum);
        totalSeconds = Integer.parseInt(properties.getProperty("TotalSeconds", String.valueOf(totalSeconds)));
        System.out.println("TotalSeconds: " + totalSeconds);
        return true;
    }

    public static void main(String[] args) {
        Thread thread;
        int i;
        if (!JavaSDKPerfTest.parseConf()) {
            return;
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setMaxConnections(threadNum);
        clientConfiguration.setMaxConnectionsPerRoute(threadNum);
        CloudAccount cloudAccount = new CloudAccount(accessId, accessKey, endpoint, clientConfiguration);
        client = cloudAccount.getMNSClient();
        CloudQueue queue = client.getQueueRef(queueName);
        queue.delete();
        QueueMeta meta = new QueueMeta();
        meta.setQueueName(queueName);
        client.createQueue(meta);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (i = 0; i < threadNum; ++i) {
            thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        CloudQueue queue = client.getQueueRef(queueName);
                        Message message = new Message();
                        message.setMessageBody("Test");
                        long count = 0L;
                        long startTime = System.currentTimeMillis();
                        System.out.println(startTime);
                        long endTime = startTime + (long)(totalSeconds * 1000);
                        do {
                            for (int i = 0; i < 50; ++i) {
                                queue.putMessage(message);
                            }
                            count += 50L;
                        } while (System.currentTimeMillis() < endTime);
                        System.out.println(System.currentTimeMillis());
                        System.out.println("Thread" + Thread.currentThread().getName() + ": " + String.valueOf(count));
                        totalCount.addAndGet(count);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, String.valueOf(i));
            thread.start();
            threads.add(thread);
        }
        for (i = 0; i < threadNum; ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("SendMessage QPS: ");
        System.out.println(totalCount.get() / (long)totalSeconds);
        threads.clear();
        totalCount.set(0L);
        totalSeconds /= 3;
        for (i = 0; i < threadNum; ++i) {
            thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        CloudQueue queue = client.getQueueRef(queueName);
                        long count = 0L;
                        long endTime = System.currentTimeMillis() + (long)(totalSeconds * 1000);
                        do {
                            for (int i = 0; i < 50; ++i) {
                                queue.popMessage();
                            }
                            count += 50L;
                        } while (System.currentTimeMillis() < endTime);
                        System.out.println("Thread" + Thread.currentThread().getName() + ": " + String.valueOf(count));
                        totalCount.addAndGet(count);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, String.valueOf(i));
            thread.start();
            threads.add(thread);
        }
        for (i = 0; i < threadNum; ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("ReceiveMessage QPS: ");
        System.out.println(totalCount.get() / (long)totalSeconds);
    }
}

