package com.aliyun.mns.model;

import com.aliyun.mns.common.MNSConstants;
import com.google.gson.Gson;

/**
 * Created by liji on 2016/11/8.
 */
public class WebSocketAttributes implements BaseAttributes {
    private Integer importanceLevel;

    @Override
    public AttributesValidationResult validate() {
        AttributesValidationResult result = new AttributesValidationResult();

        if (importanceLevel < MNSConstants.MIN_IMPORTANCE
                || importanceLevel > MNSConstants.MAX_IMPORTANCE) {
            result.setSuccess(false);
            result.setMessage("Invalid ImportanceLevel: " + importanceLevel);
            return result;
        }

        result.setSuccess(true);
        return result;
    }

    public String toJson(Gson gson) {
        return gson.toJson(this);
    }

    public Integer getImportanceLevel() {
        return importanceLevel;
    }

    public void setImportanceLevel(Integer importanceLevel) {
        this.importanceLevel = importanceLevel;
    }
}
