/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model;

import com.aliyun.mns.model.AttributesValidationResult;
import com.aliyun.mns.model.BaseAttributes;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class PushAttributes
implements BaseAttributes {
    private PushTarget target;
    private String targetValue;
    private PushDeviceType deviceType;
    private PushType pushType;
    private String title;
    private String body;
    private Map<String, String> params = new HashMap<String, String>();

    public String toJson(Gson gson) {
        return gson.toJson((Object)this);
    }

    @Override
    public AttributesValidationResult validate() {
        AttributesValidationResult result = new AttributesValidationResult();
        if (this.target == null) {
            result.setSuccess(false);
            result.setMessage("Invalid PushTarget");
            return result;
        }
        if (this.targetValue == null || this.target == PushTarget.ALL && !this.targetValue.equals("ALL")) {
            result.setSuccess(false);
            result.setMessage("Invalid TargetValue");
            return result;
        }
        if (this.deviceType == null) {
            result.setSuccess(false);
            result.setMessage("Invalid DeviceType");
            return result;
        }
        if (this.body == null) {
            result.setSuccess(false);
            result.setMessage("Invalid Body");
            return result;
        }
        if (this.title == null) {
            result.setSuccess(false);
            result.setMessage("Invalid Title");
            return result;
        }
        if (this.pushType == null) {
            this.pushType = PushType.MESSAGE;
        }
        result.setSuccess(true);
        return result;
    }

    public void setParam(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.params.put(key, value);
        }
    }

    public PushTarget getTarget() {
        return this.target;
    }

    public void setTarget(PushTarget target) {
        this.target = target;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public PushDeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(PushDeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public PushType getPushType() {
        return this.pushType;
    }

    public void setPushType(PushType pushType) {
        this.pushType = pushType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public static class PushAttributesSerializer
    implements JsonSerializer<PushAttributes> {
        public JsonElement serialize(PushAttributes pushAttributes, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Target", pushAttributes.target.name());
            jsonObject.addProperty("TargetValue", pushAttributes.targetValue);
            jsonObject.addProperty("DeviceType", pushAttributes.deviceType.name());
            jsonObject.addProperty("PushType", pushAttributes.pushType.name());
            jsonObject.addProperty("Title", pushAttributes.title);
            jsonObject.addProperty("Body", pushAttributes.body);
            for (String key : pushAttributes.params.keySet()) {
                jsonObject.addProperty(key, (String)pushAttributes.params.get(key));
            }
            return jsonObject;
        }
    }

    public static enum PushType {
        MESSAGE,
        NOTICE;

    }

    public static enum PushDeviceType {
        iOS,
        ANDROID,
        ALL;

    }

    public static enum PushTarget {
        DEVICE,
        ACCOUNT,
        ALIAS,
        TAG,
        ALL;

    }
}

