/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.SignRequest;
import com.aliyun.dkms.gcs.sdk.models.SignResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.kms.model.v20160120.AsymmetricSignRequest;
import com.aliyuncs.kms.model.v20160120.AsymmetricSignResponse;
import com.aliyuncs.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsymmetricSignTransferHandler
implements KmsTransferHandler<SignRequest, SignResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public AsymmetricSignTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public SignRequest buildDKMSRequest(AcsRequest request, RuntimeOptions runtimeOptions) throws ClientException {
        AsymmetricSignRequest asymmetricSignKmsRequest = (AsymmetricSignRequest)request;
        if (com.aliyun.tea.utils.StringUtils.isEmpty((CharSequence)asymmetricSignKmsRequest.getDigest())) {
            throw this.newMissingParameterClientException("Digest");
        }
        SignRequest signDKmsRequest = new SignRequest();
        signDKmsRequest.setKeyId(asymmetricSignKmsRequest.getKeyId());
        signDKmsRequest.setAlgorithm(asymmetricSignKmsRequest.getAlgorithm());
        signDKmsRequest.setMessage(base64.decode(asymmetricSignKmsRequest.getDigest()));
        signDKmsRequest.setMessageType("DIGEST");
        final String keyVersionId = asymmetricSignKmsRequest.getKeyVersionId();
        if (!StringUtils.isEmpty((CharSequence)keyVersionId)) {
            signDKmsRequest.setRequestHeaders((Map)new HashMap<String, String>(){
                {
                    this.put("x-kms-migrationkeyversionid", keyVersionId);
                }
            });
        }
        return signDKmsRequest;
    }

    @Override
    public SignResponse callDKMS(SignRequest dkmsRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        return this.client.signWithOptions(dkmsRequest, runtimeOptions);
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, SignResponse response) throws ClientException {
        Map responseHeaders = response.getResponseHeaders();
        String keyVersionId = null;
        if (responseHeaders != null) {
            keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid");
        }
        AsymmetricSignResponse asymmetricSignKmsResponse = new AsymmetricSignResponse();
        asymmetricSignKmsResponse.setKeyId(response.getKeyId());
        asymmetricSignKmsResponse.setKeyVersionId(keyVersionId);
        asymmetricSignKmsResponse.setValue(base64.encodeToString(response.getSignature()));
        asymmetricSignKmsResponse.setRequestId(response.getRequestId());
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)asymmetricSignKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

