/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy;

import com.aliyun.core.utils.Configuration;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class UserAgentPolicy {
    public static final String DEFAULT_USER_AGENT_HEADER = "AlibabaCloud";
    private static final String PLATFORM_INFO_FORMAT = "%s; %s; %s; %s";
    private static final int MAX_APP_ID_LENGTH = 50;
    private static String coreVersion = "unknown";

    public static String toUserAgentString(String serviceName) {
        return UserAgentPolicy.toUserAgentString(serviceName, new Configuration());
    }

    public static String toUserAgentString(String serviceName, Configuration configuration) {
        StringBuilder userAgentBuilder = new StringBuilder();
        userAgentBuilder.append(DEFAULT_USER_AGENT_HEADER).append(" ").append("TeaDSL Java Async").append(" ").append("CoreService").append("/").append(coreVersion);
        if (serviceName != null) {
            serviceName = serviceName.length() > 50 ? serviceName.substring(0, 50) : serviceName;
            userAgentBuilder.append(" ").append("alibabacloud-").append(serviceName.toLowerCase(Locale.ROOT));
        }
        if (!UserAgentPolicy.isTelemetryDisabled(configuration)) {
            userAgentBuilder.append(" ").append("(").append(UserAgentPolicy.getPlatformInfo()).append(")");
        }
        return userAgentBuilder.toString();
    }

    private static String getPlatformInfo() {
        String javaVersion = Configuration.getGlobalConfiguration().get("java.version");
        String osName = Configuration.getGlobalConfiguration().get("os.name");
        String osVersion = Configuration.getGlobalConfiguration().get("os.version");
        String osArch = Configuration.getGlobalConfiguration().get("os.arch");
        return String.format(PLATFORM_INFO_FORMAT, javaVersion, osName, osVersion, osArch);
    }

    private static boolean isTelemetryDisabled(Configuration configuration) {
        return configuration == null ? ((Boolean)Configuration.getGlobalConfiguration().get("ALI_TELEMETRY_DISABLED", (Object)false)).booleanValue() : ((Boolean)configuration.get("ALI_TELEMETRY_DISABLED", (Object)false)).booleanValue();
    }

    static {
        try {
            Properties props = new Properties();
            props.load(UserAgentPolicy.class.getClassLoader().getResourceAsStream("core.properties"));
            coreVersion = props.getProperty("sdk.project.version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

