/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.vod.model.v20170321;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.vod.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class ProduceEditingProjectVideoRequest extends RpcAcsRequest<ProduceEditingProjectVideoResponse> {
	   

	private Long resourceOwnerId;

	private String description;

	private String title;

	private String coverURL;

	private String userData;

	private String produceConfig;

	private String projectId;

	private String mediaMetadata;

	private String resourceOwnerAccount;

	private Long ownerId;

	private String timeline;
	public ProduceEditingProjectVideoRequest() {
		super("vod", "2017-03-21", "ProduceEditingProjectVideo", "vod");
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public Long getResourceOwnerId() {
		return this.resourceOwnerId;
	}

	public void setResourceOwnerId(Long resourceOwnerId) {
		this.resourceOwnerId = resourceOwnerId;
		if(resourceOwnerId != null){
			putQueryParameter("ResourceOwnerId", resourceOwnerId.toString());
		}
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
		if(description != null){
			putQueryParameter("Description", description);
		}
	}

	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
		if(title != null){
			putQueryParameter("Title", title);
		}
	}

	public String getCoverURL() {
		return this.coverURL;
	}

	public void setCoverURL(String coverURL) {
		this.coverURL = coverURL;
		if(coverURL != null){
			putQueryParameter("CoverURL", coverURL);
		}
	}

	public String getUserData() {
		return this.userData;
	}

	public void setUserData(String userData) {
		this.userData = userData;
		if(userData != null){
			putQueryParameter("UserData", userData);
		}
	}

	public String getProduceConfig() {
		return this.produceConfig;
	}

	public void setProduceConfig(String produceConfig) {
		this.produceConfig = produceConfig;
		if(produceConfig != null){
			putQueryParameter("ProduceConfig", produceConfig);
		}
	}

	public String getProjectId() {
		return this.projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
		if(projectId != null){
			putQueryParameter("ProjectId", projectId);
		}
	}

	public String getMediaMetadata() {
		return this.mediaMetadata;
	}

	public void setMediaMetadata(String mediaMetadata) {
		this.mediaMetadata = mediaMetadata;
		if(mediaMetadata != null){
			putQueryParameter("MediaMetadata", mediaMetadata);
		}
	}

	public String getResourceOwnerAccount() {
		return this.resourceOwnerAccount;
	}

	public void setResourceOwnerAccount(String resourceOwnerAccount) {
		this.resourceOwnerAccount = resourceOwnerAccount;
		if(resourceOwnerAccount != null){
			putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
		}
	}

	public Long getOwnerId() {
		return this.ownerId;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
		if(ownerId != null){
			putQueryParameter("OwnerId", ownerId.toString());
		}
	}

	public String getTimeline() {
		return this.timeline;
	}

	public void setTimeline(String timeline) {
		this.timeline = timeline;
		if(timeline != null){
			putQueryParameter("Timeline", timeline);
		}
	}

	@Override
	public Class<ProduceEditingProjectVideoResponse> getResponseClass() {
		return ProduceEditingProjectVideoResponse.class;
	}

}
