/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.edas.model.v20170801;

import com.aliyuncs.RoaAcsRequest;
import com.aliyuncs.http.MethodType;

/**
 * @author auto create
 * @version 
 */
public class UpdateApplicationBaseInfoRequest extends RoaAcsRequest<UpdateApplicationBaseInfoResponse> {
	
	public UpdateApplicationBaseInfoRequest() {
		super("Edas", "2017-08-01", "UpdateApplicationBaseInfo");
		setUriPattern("/pop/v5/app/update_app_info");
		setMethod(MethodType.POST);
	}

	private String appName;

	private String appId;

	private String desc;

	public String getAppName() {
		return this.appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
		if(appName != null){
			putQueryParameter("AppName", appName);
		}
	}

	public String getAppId() {
		return this.appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
		if(appId != null){
			putQueryParameter("AppId", appId);
		}
	}

	public String getDesc() {
		return this.desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
		if(desc != null){
			putQueryParameter("desc", desc);
		}
	}

	@Override
	public Class<UpdateApplicationBaseInfoResponse> getResponseClass() {
		return UpdateApplicationBaseInfoResponse.class;
	}

}
