/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.policy.retry.conditions;

import com.aliyuncs.policy.retry.RetryPolicyContext;
import com.aliyuncs.policy.retry.conditions.RetryCondition;
import com.aliyuncs.policy.retry.pattern.Pattern;
import java.util.HashMap;
import java.util.Map;

public final class HeadersCondition
implements RetryCondition {
    private final Map<String, Pattern> headersConditionToRetryOn;

    private HeadersCondition(Map<String, Pattern> headersToRetryOn) {
        this.headersConditionToRetryOn = new HashMap<String, Pattern>(headersToRetryOn);
    }

    @Override
    public boolean meetState(RetryPolicyContext context) {
        Map<String, String> realHeaders = context.httpHeaders();
        if (realHeaders == null) {
            return false;
        }
        for (String key : this.headersConditionToRetryOn.keySet()) {
            Pattern pattern = this.headersConditionToRetryOn.get(key);
            if (pattern == null || !realHeaders.containsKey(key)) continue;
            pattern.readFormHeadersContent(realHeaders.get(key));
            if (!pattern.meetState().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int escapeTime(RetryPolicyContext context) {
        int escapeTimeMillis = -1;
        Map<String, String> realHeaders = context.httpHeaders();
        if (realHeaders == null) {
            return -1;
        }
        for (String key : this.headersConditionToRetryOn.keySet()) {
            Pattern pattern = this.headersConditionToRetryOn.get(key);
            if (pattern == null || !realHeaders.containsKey(key)) continue;
            pattern.readFormHeadersContent(realHeaders.get(key));
            if (!pattern.meetState().booleanValue()) continue;
            escapeTimeMillis = Math.max(escapeTimeMillis, pattern.escapeTime());
        }
        return escapeTimeMillis;
    }

    public static HeadersCondition create(Map<String, Pattern> headersToRetryOn) {
        return new HeadersCondition(headersToRetryOn);
    }
}

