/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.endpoint;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.endpoint.EndpointResolverBase;
import com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.aliyuncs.endpoint.location.model.v20150612.DescribeEndpointsRequest;
import com.aliyuncs.endpoint.location.model.v20150612.DescribeEndpointsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.ProtocolType;
import java.util.HashSet;
import java.util.Set;

public class LocationServiceEndpointResolver
extends EndpointResolverBase {
    private static final String DEFAULT_LOCATION_SERVICE_ENDPOINT = "location-readonly.aliyuncs.com";
    private DefaultAcsClient client;
    private Set<String> invalidProductCodes;
    private Set<String> validProductCodes;
    private Set<String> invalidRegionIds;
    private Set<String> validRegionIds;
    private String locationServiceEndpoint = "location-readonly.aliyuncs.com";
    public int locationServiceCallCounter = 0;

    public LocationServiceEndpointResolver(DefaultAcsClient client) {
        this.client = client;
        this.invalidProductCodes = new HashSet<String>();
        this.invalidRegionIds = new HashSet<String>();
        this.validProductCodes = new HashSet<String>();
        this.validRegionIds = new HashSet<String>();
    }

    public void setLocationServiceEndpoint(String endpoint) {
        this.locationServiceEndpoint = endpoint;
    }

    @Override
    public String resolve(ResolveEndpointRequest request) throws ClientException {
        if (request.locationServiceCode == null || request.locationServiceCode.length() == 0) {
            return null;
        }
        if (this.invalidProductCodes.contains(request.productCodeLower)) {
            return null;
        }
        if (this.invalidRegionIds.contains(request.regionId)) {
            return null;
        }
        String key = this.makeEndpointKey(request);
        if (this.endpointsData.containsKey(key)) {
            return (String)this.endpointsData.get(key);
        }
        return this.getEndpointFromLocationService(key, request);
    }

    private synchronized String getEndpointFromLocationService(String key, ResolveEndpointRequest request) throws ClientException {
        if (this.endpointsData.containsKey(key)) {
            return (String)this.endpointsData.get(key);
        }
        this.callLocationService(key, request);
        ++this.locationServiceCallCounter;
        if (this.endpointsData.containsKey(key)) {
            return (String)this.endpointsData.get(key);
        }
        return null;
    }

    private void callLocationService(String key, ResolveEndpointRequest request) throws ClientException {
        DescribeEndpointsResponse response;
        DescribeEndpointsRequest describeEndpointsRequest = new DescribeEndpointsRequest();
        describeEndpointsRequest.setProtocol(ProtocolType.HTTPS);
        describeEndpointsRequest.setAcceptFormat(FormatType.JSON);
        describeEndpointsRequest.setId(request.regionId);
        describeEndpointsRequest.setServiceCode(request.locationServiceCode);
        describeEndpointsRequest.setType(request.endpointType);
        describeEndpointsRequest.setEndpoint(this.locationServiceEndpoint);
        try {
            response = this.client.getAcsResponse(describeEndpointsRequest);
        }
        catch (ClientException e) {
            if ("InvalidRegionId".equals(e.getErrCode()) && "The specified region does not exist.".equals(e.getErrMsg())) {
                this.invalidRegionIds.add(request.regionId);
                this.putEndpointEntry(key, null);
                return;
            }
            if ("Illegal Parameter".equals(e.getErrCode()) && "Please check the parameters".equals(e.getErrMsg())) {
                this.invalidProductCodes.add(request.productCodeLower);
                this.putEndpointEntry(key, null);
                return;
            }
            throw e;
        }
        this.validProductCodes.add(request.productCodeLower);
        this.validRegionIds.add(request.regionId);
        boolean foundFlag = false;
        for (DescribeEndpointsResponse.Endpoint endpoint : response.getEndpoints()) {
            if (!endpoint.getSerivceCode().equals(request.locationServiceCode) || !endpoint.getType().equals(request.endpointType)) continue;
            foundFlag = true;
            this.putEndpointEntry(key, endpoint.getEndpoint());
            break;
        }
        if (!foundFlag) {
            this.putEndpointEntry(key, null);
        }
    }

    @Override
    public boolean isProductCodeValid(ResolveEndpointRequest request) {
        if (request.locationServiceCode != null) {
            return !this.invalidProductCodes.contains(request.productCodeLower);
        }
        return false;
    }

    @Override
    public boolean isRegionIdValid(ResolveEndpointRequest request) {
        if (request.locationServiceCode != null) {
            return !this.invalidRegionIds.contains(request.regionId);
        }
        return false;
    }

    @Override
    public String makeEndpointKey(ResolveEndpointRequest request) {
        return this.makeEndpointKey(request.productCode, request.locationServiceCode, request.regionId, request.endpointType);
    }

    public String makeEndpointKey(String productCode, String locationServiceCode, String regionId, String endpointType) {
        return productCode.toLowerCase() + "." + locationServiceCode + "." + regionId.toLowerCase() + "." + endpointType;
    }
}

