/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.ISigner;
import com.aliyuncs.auth.RoaSignatureComposer;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.regions.ProductDomain;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class RoaAcsRequest<T extends AcsResponse>
extends AcsRequest<T> {
    protected String uriPattern = null;
    private Map<String, String> pathParameters = new HashMap<String, String>();

    public RoaAcsRequest(String product) {
        super(product);
        this.initialize();
    }

    public RoaAcsRequest(String product, String version) {
        super(product, version);
        this.setVersion(version);
        this.initialize();
    }

    public RoaAcsRequest(String product, String version, String action) {
        super(product);
        this.setVersion(version);
        this.setActionName(action);
        this.initialize();
    }

    private void initialize() {
        this.setAcceptFormat(FormatType.RAW);
        this.composer = RoaSignatureComposer.getComposer();
    }

    @Override
    public void setVersion(String version) {
        super.setVersion(version);
        this.putHeaderParameter("x-acs-version", version);
    }

    public Map<String, String> getPathParameters() {
        return Collections.unmodifiableMap(this.pathParameters);
    }

    protected void putPathParameter(String name, String value) {
        this.setParameter(this.pathParameters, name, value);
    }

    @Override
    public String composeUrl(String endpoint, Map<String, String> queries) throws UnsupportedEncodingException {
        String query;
        String url;
        Map<String, String> mapQueries = queries == null ? this.getQueryParameters() : queries;
        StringBuilder urlBuilder = new StringBuilder("");
        urlBuilder.append(this.getProtocol().toString());
        urlBuilder.append("://").append(endpoint);
        if (null != this.uriPattern) {
            urlBuilder.append(RoaSignatureComposer.replaceOccupiedParameters(this.uriPattern, this.getPathParameters()));
        }
        if (-1 == urlBuilder.indexOf("?")) {
            urlBuilder.append("?");
        }
        if ((url = urlBuilder.append(query = RoaAcsRequest.concatQueryString(mapQueries)).toString()).endsWith("?")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    @Override
    public HttpRequest signRequest(ISigner signer, Credential credential, FormatType format, ProductDomain domain) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException, NoSuchAlgorithmException {
        Map<String, String> imutableMap = new HashMap<String, String>(this.getHeaders());
        if (null != signer && null != credential) {
            String accessKeyId = credential.getAccessKeyId();
            String accessSecret = credential.getAccessSecret();
            imutableMap = this.composer.refreshSignParameters(this.getHeaders(), signer, accessKeyId, format);
            String strToSign = this.composer.composeStringToSign(this.getMethod(), this.getUriPattern(), signer, this.getQueryParameters(), imutableMap, this.getPathParameters());
            String signature = signer.signString(strToSign, accessSecret);
            imutableMap.put("Authorization", "acs " + accessKeyId + ":" + signature);
        }
        HttpRequest request = new HttpRequest(this.composeUrl(domain.getDomianName(), this.getQueryParameters()), imutableMap);
        request.setMethod(this.getMethod());
        request.setContent(this.getContent(), this.getEncoding(), this.getContentType());
        return request;
    }
}

