//package com.aliyun.core.utils;
//
//import com.aliyun.core.http.HttpHeaders;
//import com.aliyun.core.logging.ClientLogger;
//import org.reactivestreams.Subscriber;
//import org.reactivestreams.Subscription;
//
//import java.io.IOException;
//import java.io.InputStream;
//import java.lang.reflect.Type;
//import java.nio.ByteBuffer;
//import java.nio.channels.AsynchronousFileChannel;
//import java.nio.channels.CompletionHandler;
//import java.util.Collections;
//import java.util.Map;
//import java.util.Map.Entry;
//import java.util.Objects;
//import java.util.concurrent.CompletableFuture;
//import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
//import java.util.concurrent.atomic.AtomicLongFieldUpdater;
//import java.util.function.Function;
//import java.util.stream.Collectors;
//
//public final class BufferFutureUtil {
//    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
//
//    public static boolean isFutureByteBuffer(Type entityType) {
//        if (TypeUtil.isTypeOrSubTypeOf(entityType, CompletableFuture.class)) {
//            final Type innerType = TypeUtil.getTypeArguments(entityType)[0];
//            return TypeUtil.isTypeOrSubTypeOf(innerType, ByteBuffer.class);
//        }
//        return false;
//    }
//
//    public static CompletableFuture<byte[]> collectBytesInByteBufferStream(CompletableFuture<ByteBuffer> stream) {
//
//        return stream.collect(ByteBufferCollector::new, ByteBufferCollector::write)
//                .map(ByteBufferCollector::toByteArray);
//    }
//
//    public static CompletableFuture<byte[]> collectBytesInByteBufferStream(CompletableFuture<ByteBuffer> stream, int sizeHint) {
//        return stream.collect(() -> new ByteBufferCollector(sizeHint), ByteBufferCollector::write)
//                .map(ByteBufferCollector::toByteArray);
//    }
//
//    public static CompletableFuture<byte[]> collectBytesFromNetworkResponse(CompletableFuture<ByteBuffer> stream, HttpHeaders headers) {
//        Objects.requireNonNull(headers, "'headers' cannot be null.");
//
//        String contentLengthHeader = headers.getValue("Content-Length");
//
//        if (contentLengthHeader == null) {
//            return BufferFutureUtil.collectBytesInByteBufferStream(stream);
//        } else {
//            try {
//                int contentLength = Integer.parseInt(contentLengthHeader);
//                if (contentLength > 0) {
//                    return BufferFutureUtil.collectBytesInByteBufferStream(stream, contentLength);
//                } else {
//                    return CompletableFuture.completedFuture(EMPTY_BYTE_ARRAY);
//                }
//            } catch (NumberFormatException ex) {
//                return BufferFutureUtil.collectBytesInByteBufferStream(stream);
//            }
//        }
//    }
//
//    public static byte[] byteBufferToArray(ByteBuffer byteBuffer) {
//        int length = byteBuffer.remaining();
//        byte[] byteArray = new byte[length];
//        byteBuffer.get(byteArray);
//        return byteArray;
//    }
//
//    public static CompletableFuture<ByteBuffer> toByteBuffer(InputStream inputStream) {
//        return toByteBuffer(inputStream, 4096);
//    }
//
//    public static CompletableFuture<ByteBuffer> toByteBuffer(InputStream inputStream, int chunkSize) {
//        if (chunkSize <= 0) {
//            throw  new IllegalArgumentException("'chunkSize' must be greater than 0.");
//        }
//
//        if (inputStream == null) {
//            return CompletableFuture.completedFuture(null);
//        }
//
//        return Flux.<ByteBuffer, InputStream>generate(() -> inputStream, (stream, sink) -> {
//            byte[] buffer = new byte[chunkSize];
//
//            try {
//                int offset = 0;
//
//                while (offset < chunkSize) {
//                    int readCount = inputStream.read(buffer, offset, chunkSize - offset);
//
//                    // We have finished reading the stream, trigger onComplete.
//                    if (readCount == -1) {
//                        // If there were bytes read before reaching the end emit the buffer before completing.
//                        if (offset > 0) {
//                            sink.next(ByteBuffer.wrap(buffer, 0, offset));
//                        }
//                        sink.complete();
//                        return stream;
//                    }
//
//                    offset += readCount;
//                }
//
//                sink.next(ByteBuffer.wrap(buffer));
//            } catch (IOException ex) {
//                sink.error(ex);
//            }
//
//            return stream;
//        }).filter(ByteBuffer::hasRemaining);
//    }
//
//    public static CompletableFuture<Void> writeFile(CompletableFuture<ByteBuffer> content, AsynchronousFileChannel outFile) {
//        return writeFile(content, outFile, 0);
//    }
//
//    public static CompletableFuture<Void> writeFile(CompletableFuture<ByteBuffer> content, AsynchronousFileChannel outFile, long position) {
//        return CompletableFuture.supplyAsync(new Subscriber<ByteBuffer>() {
//            volatile boolean isWriting = false;
//            volatile boolean isCompleted = false;
//            volatile Subscription subscription;
//            volatile long pos = position;
//
//            @Override
//            public void onSubscribe(Subscription s) {
//                subscription = s;
//                s.request(1);
//            }
//
//            @Override
//            public void onNext(ByteBuffer bytes) {
//                isWriting = true;
//                outFile.write(bytes, pos, null, onWriteCompleted);
//            }
//
//
//            final CompletionHandler<Integer, Object> onWriteCompleted = new CompletionHandler<Integer, Object>() {
//                @Override
//                public void completed(Integer bytesWritten, Object attachment) {
//                    isWriting = false;
//                    if (isCompleted) {
//                        return;
//                    }
//                    //noinspection NonAtomicOperationOnVolatileField
//                    pos += bytesWritten;
//                    subscription.request(1);
//                }
//
//                @Override
//                public void failed(Throwable exc, Object attachment) {
//                    subscription.cancel();
//                    return;
//                }
//            };
//
//            @Override
//            public void onError(Throwable throwable) {
//                subscription.cancel();
//                return;
//            }
//
//            @Override
//            public void onComplete() {
//                isCompleted = true;
//                if (!isWriting) {
//                    return;
//                }
//            }
//        }));
//    }
//
//    public static CompletableFuture<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, int chunkSize, long offset,
//                                            long length) {
//        return new FileReadFlux(fileChannel, chunkSize, offset, length);
//    }
//
//    public static CompletableFuture<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, long offset, long length) {
//        return readFile(fileChannel, DEFAULT_CHUNK_SIZE, offset, length);
//    }
//
//    public static CompletableFuture<ByteBuffer> readFile(AsynchronousFileChannel fileChannel) {
//        try {
//            long size = fileChannel.size();
//            return readFile(fileChannel, DEFAULT_CHUNK_SIZE, 0, size);
//        } catch (IOException e) {
//            return Flux.error(new RuntimeException("Failed to read the file.", e));
//        }
//    }
//
//    private static final int DEFAULT_CHUNK_SIZE = 1024 * 64;
//
//    private static final class FileReadFlux extends CompletableFuture<ByteBuffer> {
//        private final AsynchronousFileChannel fileChannel;
//        private final int chunkSize;
//        private final long offset;
//        private final long length;
//
//        FileReadFlux(AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
//            this.fileChannel = fileChannel;
//            this.chunkSize = chunkSize;
//            this.offset = offset;
//            this.length = length;
//        }
//
//        @Override
//        public void subscribe(CoreSubscriber<? super ByteBuffer> actual) {
//            FileReadSubscription subscription =
//                    new FileReadSubscription(actual, fileChannel, chunkSize, offset, length);
//            actual.onSubscribe(subscription);
//        }
//
//        static final class FileReadSubscription implements Subscription, CompletionHandler<Integer, ByteBuffer> {
//            private static final int NOT_SET = -1;
//            private static final long serialVersionUID = -6831808726875304256L;
//            private final Subscriber<? super ByteBuffer> subscriber;
//            private volatile long position;
//            private final AsynchronousFileChannel fileChannel;
//            private final int chunkSize;
//            private final long offset;
//            private final long length;
//            private volatile boolean done;
//            private Throwable error;
//            private volatile ByteBuffer next;
//            private volatile boolean cancelled;
//            volatile int wip;
//            @SuppressWarnings("rawtypes")
//            static final AtomicIntegerFieldUpdater<FileReadSubscription> WIP =
//                    AtomicIntegerFieldUpdater.newUpdater(FileReadSubscription.class, "wip");
//            volatile long requested;
//            @SuppressWarnings("rawtypes")
//            static final AtomicLongFieldUpdater<FileReadSubscription> REQUESTED =
//                    AtomicLongFieldUpdater.newUpdater(FileReadSubscription.class, "requested");
//
//            FileReadSubscription(Subscriber<? super ByteBuffer> subscriber, AsynchronousFileChannel fileChannel,
//                                 int chunkSize, long offset, long length) {
//                this.subscriber = subscriber;
//                this.fileChannel = fileChannel;
//                this.chunkSize = chunkSize;
//                this.offset = offset;
//                this.length = length;
//                this.position = NOT_SET;
//            }
//
//            @Override
//            public void request(long n) {
//                if (Operators.validate(n)) {
//                    Operators.addCap(REQUESTED, this, n);
//                    drain();
//                }
//            }
//
//            @Override
//            public void cancel() {
//                this.cancelled = true;
//            }
//
//            @Override
//            public void completed(Integer bytesRead, ByteBuffer buffer) {
//                if (!cancelled) {
//                    if (bytesRead == -1) {
//                        done = true;
//                    } else {
//                        // use local variable to perform fewer volatile reads
//                        long pos = position;
//                        int bytesWanted = Math.min(bytesRead, maxRequired(pos));
//                        long position2 = pos + bytesWanted;
//                        //noinspection NonAtomicOperationOnVolatileField
//                        position = position2;
//                        buffer.position(bytesWanted);
//                        buffer.flip();
//                        next = buffer;
//                        if (position2 >= offset + length) {
//                            done = true;
//                        }
//                    }
//                    drain();
//                }
//            }
//
//            @Override
//            public void failed(Throwable exc, ByteBuffer attachment) {
//                if (!cancelled) {
//                    // must set error before setting done to true
//                    // so that is visible in drain loop
//                    error = exc;
//                    done = true;
//                    drain();
//                }
//            }
//
//            //endregion
//
//            private void drain() {
//                if (WIP.getAndIncrement(this) != 0) {
//                    return;
//                }
//                // on first drain (first request) we initiate the first read
//                if (position == NOT_SET) {
//                    position = offset;
//                    doRead();
//                }
//                int missed = 1;
//                while (true) {
//                    if (cancelled) {
//                        return;
//                    }
//                    if (REQUESTED.get(this) > 0) {
//                        boolean emitted = false;
//                        // read d before next to avoid race
//                        boolean d = done;
//                        ByteBuffer bb = next;
//                        if (bb != null) {
//                            next = null;
//                            subscriber.onNext(bb);
//                            emitted = true;
//                        }
//                        if (d) {
//                            if (error != null) {
//                                subscriber.onError(error);
//                            } else {
//                                subscriber.onComplete();
//                            }
//
//                            // exit without reducing wip so that further drains will be NOOP
//                            return;
//                        }
//                        if (emitted) {
//                            // do this after checking d to avoid calling read
//                            // when done
//                            Operators.produced(REQUESTED, this, 1);
//                            //
//                            doRead();
//                        }
//                    }
//                    missed = WIP.addAndGet(this, -missed);
//                    if (missed == 0) {
//                        return;
//                    }
//                }
//            }
//
//            private void doRead() {
//                // use local variable to limit volatile reads
//                long pos = position;
//                ByteBuffer innerBuf = ByteBuffer.allocate(Math.min(chunkSize, maxRequired(pos)));
//                fileChannel.read(innerBuf, pos, innerBuf, this);
//            }
//
//            private int maxRequired(long pos) {
//                long maxRequired = offset + length - pos;
//                if (maxRequired <= 0) {
//                    return 0;
//                } else {
//                    int m = (int) (maxRequired);
//                    // support really large files by checking for overflow
//                    if (m < 0) {
//                        return Integer.MAX_VALUE;
//                    } else {
//                        return m;
//                    }
//                }
//            }
//        }
//    }
//
//    private BufferFutureUtil() {
//    }
//}
