/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.signature.signer;

import com.aliyun.auth.signature.exception.SignatureException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;

public enum SignAlgorithmSHA256withRSA {
    SHA256withRSA("SHA256withRSA", "RSA");

    private final ThreadLocal<Signature> reference;
    private final String algorithmName;
    private final String keyName;

    private SignAlgorithmSHA256withRSA(String algorithmName, String keyName) {
        this.algorithmName = algorithmName;
        this.keyName = keyName;
        this.reference = new MacThreadLocal(algorithmName);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String toString() {
        return this.keyName;
    }

    public Signature getSignature() {
        return this.reference.get();
    }

    private static class MacThreadLocal
    extends ThreadLocal<Signature> {
        private final String algorithmName;

        MacThreadLocal(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        protected Signature initialValue() {
            try {
                return Signature.getInstance(this.algorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SignatureException("Unable to fetch Signature instance for Algorithm " + this.algorithmName + e.getMessage());
            }
        }
    }
}

