/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.core.utils.StringUtils;

public class SystemPropertiesCredentialProvider
implements ICredentialProvider {
    public static SystemPropertiesCredentialProvider create() {
        return new SystemPropertiesCredentialProvider();
    }

    @Override
    public ICredential getCredentials() throws CredentialException {
        String accessKeyId = System.getProperty("alibabacloud.accessKeyId");
        String accessKeySecret = System.getProperty("alibabacloud.accessKeyIdSecret");
        if (StringUtils.isEmpty((CharSequence)accessKeyId) || StringUtils.isEmpty((CharSequence)accessKeySecret)) {
            throw new CredentialException("System Properties variable accessKeyId/accessKeySecret cannot be empty");
        }
        return Credential.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).build();
    }

    public void close() {
    }
}

