/*
 * Decompiled with CFR 0.152.
 */
package com.alicom.mns.tools;

import com.alicom.mns.tools.TokenForAlicom;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dybaseapi.model.v20170525.QueryTokenForMnsQueueRequest;
import com.aliyuncs.dybaseapi.model.v20170525.QueryTokenForMnsQueueResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TokenGetterForAlicom {
    private Log logger = LogFactory.getLog(TokenGetterForAlicom.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String endpointNameForPop;
    private String regionIdForPop;
    private String domainForPop;
    private IAcsClient iAcsClient;
    private Long ownerId;
    private static final String productName = "Dybaseapi";
    private long bufferTime = 120000L;
    private final Object lock = new Object();
    private ConcurrentMap<String, TokenForAlicom> tokenMap = new ConcurrentHashMap<String, TokenForAlicom>();

    public TokenGetterForAlicom(String accessKeyId, String accessKeySecret, String endpointNameForPop, String regionIdForPop, String domainForPop, Long ownerId) throws ClientException {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endpointNameForPop = endpointNameForPop;
        this.regionIdForPop = regionIdForPop;
        this.domainForPop = domainForPop;
        this.ownerId = ownerId;
        this.init();
    }

    private void init() throws ClientException {
        DefaultProfile.addEndpoint((String)this.endpointNameForPop, (String)this.regionIdForPop, (String)productName, (String)this.domainForPop);
        DefaultProfile profile = DefaultProfile.getProfile((String)this.regionIdForPop, (String)this.accessKeyId, (String)this.accessKeySecret);
        this.iAcsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    private TokenForAlicom getTokenFromRemote(String messageType, String queueName) throws ServerException, ClientException, ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QueryTokenForMnsQueueRequest request = new QueryTokenForMnsQueueRequest();
        request.setAcceptFormat(FormatType.JSON);
        request.setMessageType(messageType);
        request.setQueueName(queueName);
        request.setOwnerId(this.ownerId);
        request.setProtocol(ProtocolType.HTTPS);
        QueryTokenForMnsQueueResponse response = (QueryTokenForMnsQueueResponse)this.iAcsClient.getAcsResponse((AcsRequest)request);
        String resultCode = response.getCode();
        if (resultCode != null && "OK".equals(resultCode)) {
            QueryTokenForMnsQueueResponse.MessageTokenDTO dto = response.getMessageTokenDTO();
            TokenForAlicom token = new TokenForAlicom();
            String timeStr = dto.getExpireTime();
            token.setMessageType(messageType);
            token.setExpireTime(df.parse(timeStr).getTime());
            token.setToken(dto.getSecurityToken());
            token.setTempAccessKeyId(dto.getAccessKeyId());
            token.setTempAccessKeySecret(dto.getAccessKeySecret());
            return token;
        }
        this.logger.error((Object)("getTokenFromRemote_error,messageType:" + messageType + ",code:" + response.getCode() + ",message:" + response.getMessage()));
        throw new ServerException(response.getCode(), response.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenForAlicom getTokenByMessageType(String messageType, String queueName, String mnsAccountEndpoint) throws ServerException, ClientException, ParseException {
        TokenForAlicom token = (TokenForAlicom)this.tokenMap.get(messageType);
        Long now = System.currentTimeMillis();
        if (token == null || token.getExpireTime() - now < this.bufferTime) {
            Object object = this.lock;
            synchronized (object) {
                token = (TokenForAlicom)this.tokenMap.get(messageType);
                if (token == null || token.getExpireTime() - now < this.bufferTime) {
                    TokenForAlicom oldToken = null;
                    if (token != null) {
                        oldToken = token;
                    }
                    token = this.getTokenFromRemote(messageType, queueName);
                    CloudAccount account = new CloudAccount(token.getTempAccessKeyId(), token.getTempAccessKeySecret(), mnsAccountEndpoint, token.getToken());
                    MNSClient client = account.getMNSClient();
                    CloudQueue queue = client.getQueueRef(queueName);
                    token.setClient(client);
                    token.setQueue(queue);
                    this.tokenMap.put(messageType, token);
                    if (oldToken != null) {
                        oldToken.closeClient();
                    }
                }
            }
        }
        return token;
    }
}

