/*
 * Decompiled with CFR 0.152.
 */
package com.alicom.mns.tools;

import com.alicom.mns.tools.MessageListener;
import com.alicom.mns.tools.TokenForAlicom;
import com.alicom.mns.tools.TokenGetterForAlicom;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.aliyuncs.exceptions.ClientException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultAlicomMessagePuller {
    private String mnsAccountEndpoint = "https://1943695596114318.mns.cn-hangzhou.aliyuncs.com/";
    private String endpointNameForPop = "cn-hangzhou";
    private String regionIdForPop = "cn-hangzhou";
    private String domainForPop = "dybaseapi.aliyuncs.com";
    private TokenGetterForAlicom tokenGetter;
    private MessageListener messageListener;
    private Log logger = LogFactory.getLog(DefaultAlicomMessagePuller.class);
    private boolean isRunning = false;
    private Integer sleepMillsWhenNoData = 3000;
    private Integer consumeMinThreadSize = 6;
    private Integer consumeMaxThreadSize = 16;
    private Integer pullMsgThreadSize = 1;
    private Integer threadQueueSize = 200;
    private boolean debugLogOpen = false;

    public void openDebugLog(boolean debugLogOpen) {
    }

    public Integer getSleepMillsWhenNoData() {
        return this.sleepMillsWhenNoData;
    }

    public void setSleepMillsWhenNoData(Integer sleepMillsWhenNoData) {
        this.sleepMillsWhenNoData = sleepMillsWhenNoData;
    }

    public Integer getConsumeMinThreadSize() {
        return this.consumeMinThreadSize;
    }

    public void setConsumeMinThreadSize(Integer consumeMinThreadSize) {
        if (consumeMinThreadSize != null && consumeMinThreadSize > 0) {
            this.consumeMinThreadSize = consumeMinThreadSize;
        }
    }

    public Integer getConsumeMaxThreadSize() {
        return this.consumeMaxThreadSize;
    }

    public void setConsumeMaxThreadSize(Integer consumeMaxThreadSize) {
        if (consumeMaxThreadSize != null && consumeMaxThreadSize > 0) {
            this.consumeMaxThreadSize = consumeMaxThreadSize;
        }
    }

    public Integer getPullMsgThreadSize() {
        return this.pullMsgThreadSize;
    }

    public void setPullMsgThreadSize(Integer pullMsgThreadSize) {
        if (pullMsgThreadSize != null && pullMsgThreadSize > 1) {
            this.pullMsgThreadSize = pullMsgThreadSize;
        }
    }

    public Integer getThreadQueueSize() {
        return this.threadQueueSize;
    }

    public void setThreadQueueSize(Integer threadQueueSize) {
        if (threadQueueSize != null && threadQueueSize > 0 && threadQueueSize < 20) {
            this.threadQueueSize = threadQueueSize;
        }
    }

    public void startReceiveMsg(String accessKeyId, String accessKeySecret, String messageType, String queueName, MessageListener messageListener) throws ClientException, ParseException {
        this.tokenGetter = new TokenGetterForAlicom(accessKeyId, accessKeySecret, this.endpointNameForPop, this.regionIdForPop, this.domainForPop, null);
        this.messageListener = messageListener;
        this.isRunning = true;
        PullMessageTask task = new PullMessageTask();
        task.messageType = messageType;
        task.queueName = queueName;
        for (int i = 0; i < this.pullMsgThreadSize; ++i) {
            Thread thread = new Thread((Runnable)task, "PullMessageTask-thread-" + i);
            thread.start();
        }
    }

    public void startReceiveMsgForPartnerUser(String accessKeyId, String accessKeySecret, Long ownerId, String messageType, String queueName, MessageListener messageListener) throws ClientException, ParseException {
        this.tokenGetter = new TokenGetterForAlicom(accessKeyId, accessKeySecret, this.endpointNameForPop, this.regionIdForPop, this.domainForPop, ownerId);
        this.messageListener = messageListener;
        this.isRunning = true;
        PullMessageTask task = new PullMessageTask();
        task.messageType = messageType;
        task.queueName = queueName;
        for (int i = 0; i < this.pullMsgThreadSize; ++i) {
            Thread thread = new Thread((Runnable)task, "PullMessageTask-thread-" + i);
            thread.start();
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    private class PullMessageTask
    implements Runnable {
        private String messageType;
        private String queueName;
        private ExecutorService cachedThreadPool = null;

        private PullMessageTask() {
        }

        @Override
        public void run() {
            this.cachedThreadPool = new ThreadPoolExecutor(DefaultAlicomMessagePuller.this.consumeMinThreadSize, DefaultAlicomMessagePuller.this.consumeMaxThreadSize, 30L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(DefaultAlicomMessagePuller.this.threadQueueSize));
            while (DefaultAlicomMessagePuller.this.isRunning) {
                try {
                    TokenForAlicom tokenObject = DefaultAlicomMessagePuller.this.tokenGetter.getTokenByMessageType(this.messageType, this.queueName, DefaultAlicomMessagePuller.this.mnsAccountEndpoint);
                    final CloudQueue queue = tokenObject.getQueue();
                    if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        DefaultAlicomMessagePuller.this.logger.warn((Object)(Thread.currentThread().getName() + "-popStart at " + "," + format.format(new Date())));
                    }
                    List popMsg = queue.batchPopMessage(16);
                    if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        DefaultAlicomMessagePuller.this.logger.warn((Object)(Thread.currentThread().getName() + "-popDone at " + "," + format.format(new Date()) + " msgSize=" + (popMsg == null ? 0 : popMsg.size())));
                    }
                    if (popMsg == null || popMsg.size() <= 0) continue;
                    for (final Message message : popMsg) {
                        this.cachedThreadPool.execute(new Thread(){

                            @Override
                            public void run() {
                                if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    DefaultAlicomMessagePuller.this.logger.warn((Object)(message.getMessageId() + "," + "receive" + "," + format.format(new Date())));
                                }
                                boolean dealResult = DefaultAlicomMessagePuller.this.messageListener.dealMessage(message);
                                if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    DefaultAlicomMessagePuller.this.logger.warn((Object)(message.getMessageId() + "," + "consumeResult" + dealResult + "," + format.format(new Date())));
                                }
                                if (dealResult) {
                                    queue.deleteMessage(message.getReceiptHandle());
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    DefaultAlicomMessagePuller.this.logger.error((Object)("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName), (Throwable)e);
                    try {
                        Thread.sleep(DefaultAlicomMessagePuller.this.sleepMillsWhenNoData.intValue());
                    }
                    catch (InterruptedException e1) {
                        DefaultAlicomMessagePuller.this.logger.error((Object)("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName), (Throwable)e);
                    }
                }
            }
        }
    }
}

