/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dkms.gcs.openapi;

import com.aliyun.dkms.gcs.openapi.credential.models.Config;
import com.aliyun.dkms.gcs.openapi.models.ResponseEntity;
import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tea.utils.StringUtils;
import com.aliyun.teautil.Common;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Client {
    public String _endpoint;
    public String _regionId;
    public String _protocol;
    public Number _readTimeout;
    public Number _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _noProxy;
    public String _userAgent;
    public String _socks5Proxy;
    public String _socks5NetWork;
    public Number _maxIdleConns;
    public com.aliyun.dkms.gcs.openapi.credential.Client _credential;
    public String _ca;

    public Client(com.aliyun.dkms.gcs.openapi.models.Config config) throws Exception {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        if (Common.empty((String)config.endpoint)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.endpoint' can not be empty")}));
        }
        if (!Common.empty((String)config.clientKeyContent)) {
            config.type = "rsa_key_pair";
            Config contentConfig = Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("type", (Object)config.type), new TeaPair("clientKeyContent", (Object)config.clientKeyContent), new TeaPair("password", (Object)config.password)}));
            this._credential = new com.aliyun.dkms.gcs.openapi.credential.Client(contentConfig);
        } else if (!Common.empty((String)config.clientKeyFile)) {
            config.type = "rsa_key_pair";
            Config clientKeyConfig = Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("type", (Object)config.type), new TeaPair("clientKeyFile", (Object)config.clientKeyFile), new TeaPair("password", (Object)config.password)}));
            this._credential = new com.aliyun.dkms.gcs.openapi.credential.Client(clientKeyConfig);
        } else if (!Common.empty((String)config.accessKeyId) && !Common.empty((String)config.privateKey)) {
            config.type = "rsa_key_pair";
            Config credentialConfig = Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("type", (Object)config.type), new TeaPair("accessKeyId", (Object)config.accessKeyId), new TeaPair("privateKey", (Object)config.privateKey)}));
            this._credential = new com.aliyun.dkms.gcs.openapi.credential.Client(credentialConfig);
        } else if (!Common.isUnset((Object)config.credential)) {
            this._credential = config.credential;
        }
        if (!StringUtils.isEmpty((CharSequence)config.ca)) {
            this._ca = com.aliyun.dkms.gcs.openapi.util.Client.getCaCertFromContent((byte[])config.ca.getBytes(StandardCharsets.UTF_8));
        } else if (!StringUtils.isEmpty((CharSequence)config.caFilePath)) {
            this._ca = com.aliyun.dkms.gcs.openapi.util.Client.getCaCertFromFile((String)config.caFilePath);
        }
        this._endpoint = config.endpoint;
        this._protocol = config.protocol;
        this._regionId = config.regionId;
        this._userAgent = config.userAgent;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = config.maxIdleConns;
    }

    public ResponseEntity doRequest(String apiName, String apiVersion, String protocol, String method, String signatureMethod, byte[] reqBodyBytes, RuntimeOptions runtime, Map<String, String> requestHeaders) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("socks5Proxy", (Object)Common.defaultString((String)runtime.socks5Proxy, (String)this._socks5Proxy)), new TeaPair("socks5NetWork", (Object)Common.defaultString((String)runtime.socks5NetWork, (String)this._socks5NetWork)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        if (!(runtime.ignoreSSL != null && runtime.ignoreSSL.booleanValue() || StringUtils.isEmpty((CharSequence)this._ca))) {
            runtime_.put("ca", this._ca);
        }
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = "/";
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[0]);
                if (requestHeaders != null && requestHeaders.size() > 0) {
                    request_.headers.putAll(requestHeaders);
                }
                request_.headers.put("accept", "application/x-protobuf");
                request_.headers.put("host", com.aliyun.dkms.gcs.openapi.util.Client.getHost((String)this._regionId, (String)this._endpoint));
                request_.headers.put("date", Common.getDateUTCString());
                request_.headers.put("user-agent", Common.getUserAgent((String)this._userAgent));
                request_.headers.put("x-kms-apiversion", apiVersion);
                request_.headers.put("x-kms-apiname", apiName);
                request_.headers.put("x-kms-signaturemethod", signatureMethod);
                request_.headers.put("x-kms-acccesskeyid", this._credential.getAccessKeyId());
                request_.headers.put("content-type", "application/x-protobuf");
                request_.headers.put("content-length", com.aliyun.dkms.gcs.openapi.util.Client.getContentLength((byte[])reqBodyBytes));
                request_.headers.put("content-sha256", com.aliyun.dkms.gcs.openapi.util.Client.getContentSHA256((byte[])reqBodyBytes));
                request_.body = Tea.toReadable((byte[])reqBodyBytes);
                String strToSign = com.aliyun.dkms.gcs.openapi.util.Client.getStringToSign((TeaRequest)request_);
                request_.headers.put("authorization", this._credential.getSignature(strToSign));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                byte[] bodyBytes = null;
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    bodyBytes = Common.readAsBytes((InputStream)response_.body);
                    Map respMap = com.aliyun.dkms.gcs.openapi.util.Client.getErrMessage((byte[])bodyBytes);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", respMap.get("Code")), new TeaPair("message", respMap.get("Message")), new TeaPair("data", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("httpCode", (Object)response_.statusCode), new TeaPair("requestId", respMap.get("RequestId")), new TeaPair("hostId", respMap.get("HostId"))}))}));
                }
                bodyBytes = Common.readAsBytes((InputStream)response_.body);
                HashMap responseHeaders = null;
                if (runtime.getResponseHeaders() != null && runtime.getResponseHeaders().size() > 0) {
                    responseHeaders = new HashMap();
                    for (String header : runtime.getResponseHeaders()) {
                        if (!response_.headers.containsKey(header)) continue;
                        responseHeaders.put(header, response_.headers.get(header));
                    }
                }
                return new ResponseEntity(bodyBytes, responseHeaders);
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }
}

