/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.xplatform.asf.cache.memcached;

import com.alisoft.xplatform.asf.cache.ICacheManager;
import com.alisoft.xplatform.asf.cache.IMemcachedCache;
import com.alisoft.xplatform.asf.cache.memcached.CacheUtil;
import com.alisoft.xplatform.asf.cache.memcached.MemCachedClientHelper;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedCache;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientCluster;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientClusterConfig;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientConfig;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientSocketPoolConfig;
import com.alisoft.xplatform.asf.cache.memcached.client.ErrorHandler;
import com.alisoft.xplatform.asf.cache.memcached.client.MemCachedClient;
import com.alisoft.xplatform.asf.cache.memcached.client.SockIOPool;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedCacheManager
implements ICacheManager<IMemcachedCache> {
    private static final Log Logger = LogFactory.getLog(MemcachedCacheManager.class);
    private static final String MEMCACHED_CONFIG_FILE = "memcached.xml";
    private ConcurrentHashMap<String, IMemcachedCache> cachepool;
    private ConcurrentHashMap<String, SockIOPool> socketpool;
    private ConcurrentHashMap<String, MemcachedClientCluster> clusterpool;
    private ConcurrentHashMap<IMemcachedCache, MemcachedClientCluster> cache2cluster;
    private List<MemcachedClientConfig> memcachedClientconfigs;
    private List<MemcachedClientSocketPoolConfig> memcachedClientSocketPoolConfigs;
    private List<MemcachedClientClusterConfig> memcachedClientClusterConfigs;
    private boolean supportMultiConfig = false;
    private String configFile;
    private int responseStatInterval = 0;

    @Override
    public void start() {
        this.cachepool = new ConcurrentHashMap();
        this.socketpool = new ConcurrentHashMap();
        this.clusterpool = new ConcurrentHashMap();
        this.cache2cluster = new ConcurrentHashMap();
        this.memcachedClientconfigs = new ArrayList<MemcachedClientConfig>();
        this.memcachedClientSocketPoolConfigs = new ArrayList<MemcachedClientSocketPoolConfig>();
        this.memcachedClientClusterConfigs = new ArrayList<MemcachedClientClusterConfig>();
        this.loadConfig(this.configFile);
        if (this.memcachedClientconfigs != null && this.memcachedClientconfigs.size() > 0 && this.memcachedClientSocketPoolConfigs != null && this.memcachedClientSocketPoolConfigs.size() > 0) {
            try {
                this.initMemCacheClientPool();
            }
            catch (Exception ex) {
                Logger.error((Object)"MemcachedManager init error ,please check !");
                throw new RuntimeException("MemcachedManager init error ,please check !", ex);
            }
        } else {
            Logger.error((Object)"no config info for MemcachedManager,please check !");
            throw new RuntimeException("no config info for MemcachedManager,please check !");
        }
    }

    protected void loadConfig(String configFile) {
        try {
            if (this.supportMultiConfig) {
                Enumeration<URL> urls = null;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                urls = configFile != null && !configFile.equals("") ? loader.getResources(configFile) : loader.getResources(MEMCACHED_CONFIG_FILE);
                XMLInputFactory factory = XMLInputFactory.newInstance();
                if (urls == null || !urls.hasMoreElements()) {
                    Logger.error((Object)"no memcached config find! please put memcached.xml in your classpath");
                    throw new RuntimeException("no memcached config find! please put memcached.xml in your classpath");
                }
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    CacheUtil.loadMemcachedConfigFromURL(url, factory, this.memcachedClientconfigs, this.memcachedClientSocketPoolConfigs, this.memcachedClientClusterConfigs);
                    Logger.info((Object)new StringBuilder().append("load config from :").append(url.getFile()));
                }
            } else {
                URL url = null;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                url = configFile != null && !configFile.equals("") ? (configFile.startsWith("http") ? new URL(configFile) : loader.getResource(configFile)) : loader.getResource(MEMCACHED_CONFIG_FILE);
                XMLInputFactory factory = XMLInputFactory.newInstance();
                if (url == null) {
                    Logger.error((Object)"no memcached config find! please put memcached.xml in your classpath");
                    throw new RuntimeException("no memcached config find! please put memcached.xml in your classpath");
                }
                CacheUtil.loadMemcachedConfigFromURL(url, factory, this.memcachedClientconfigs, this.memcachedClientSocketPoolConfigs, this.memcachedClientClusterConfigs);
                Logger.info((Object)new StringBuilder().append("load config from :").append(url.getFile()));
            }
        }
        catch (Exception ex) {
            Logger.error((Object)"MemcachedManager loadConfig error !");
            throw new RuntimeException("MemcachedManager loadConfig error !", ex);
        }
    }

    protected void initMemCacheClientPool() {
        for (MemcachedClientSocketPoolConfig memcachedClientSocketPoolConfig : this.memcachedClientSocketPoolConfigs) {
            if (memcachedClientSocketPoolConfig != null && memcachedClientSocketPoolConfig.getServers() != null && !memcachedClientSocketPoolConfig.getServers().equals("")) {
                SockIOPool pool = SockIOPool.getNewInstance(memcachedClientSocketPoolConfig.getName());
                String[] servers = memcachedClientSocketPoolConfig.getServers().split(",");
                String[] weights = null;
                if (memcachedClientSocketPoolConfig.getWeights() != null && !memcachedClientSocketPoolConfig.getWeights().equals("")) {
                    weights = memcachedClientSocketPoolConfig.getWeights().split(",");
                }
                pool.setServers(servers);
                if (weights != null && weights.length > 0 && weights.length == servers.length) {
                    Integer[] weightsarr = new Integer[weights.length];
                    for (int i = 0; i < weights.length; ++i) {
                        weightsarr[i] = new Integer(weights[i]);
                    }
                    pool.setWeights(weightsarr);
                }
                pool.setInitConn(memcachedClientSocketPoolConfig.getInitConn());
                pool.setMinConn(memcachedClientSocketPoolConfig.getMinConn());
                pool.setMaxConn(memcachedClientSocketPoolConfig.getMaxConn());
                pool.setMaintSleep(memcachedClientSocketPoolConfig.getMaintSleep());
                pool.setSocketTO(memcachedClientSocketPoolConfig.getSocketTo());
                pool.setNagle(memcachedClientSocketPoolConfig.isNagle());
                pool.setFailover(memcachedClientSocketPoolConfig.isFailover());
                pool.setAliveCheck(memcachedClientSocketPoolConfig.isAliveCheck());
                pool.setMaxIdle(memcachedClientSocketPoolConfig.getMaxIdle());
                pool.initialize();
                if (this.socketpool.get(memcachedClientSocketPoolConfig.getName()) != null) {
                    Logger.error((Object)new StringBuilder("socketpool define duplicate! socketpool name:").append(memcachedClientSocketPoolConfig.getName()));
                }
                this.socketpool.put(memcachedClientSocketPoolConfig.getName(), pool);
                Logger.info((Object)new StringBuilder().append(" add socketpool :").append(memcachedClientSocketPoolConfig.getName()));
                continue;
            }
            Logger.error((Object)"MemcachedClientSocketPool config error !");
            throw new RuntimeException("MemcachedClientSocketPool config error !");
        }
        for (MemcachedClientConfig memcachedClientConfig : this.memcachedClientconfigs) {
            MemCachedClientHelper helper = new MemCachedClientHelper();
            MemcachedCache cache = new MemcachedCache(helper, this.responseStatInterval);
            MemCachedClient client = new MemCachedClient(memcachedClientConfig.getSocketPool());
            client.setCompressEnable(memcachedClientConfig.isCompressEnable());
            client.setDefaultEncoding(memcachedClientConfig.getDefaultEncoding());
            try {
                if (memcachedClientConfig.getErrorHandler() != null && !memcachedClientConfig.getErrorHandler().equals("")) {
                    client.setErrorHandler((ErrorHandler)Class.forName(memcachedClientConfig.getErrorHandler()).newInstance());
                }
            }
            catch (Exception ex) {
                Logger.error((Object)new StringBuilder().append("Not find class name:").append(memcachedClientConfig.getErrorHandler()).append("please check space char or tab char"));
            }
            helper.setCacheName(memcachedClientConfig.getName());
            helper.setCacheClient(client);
            helper.setCacheManager(this);
            helper.setMemcachedCache(cache);
            if (this.cachepool.get(memcachedClientConfig.getName()) != null) {
                Logger.error((Object)new StringBuilder("cache define duplicate! cache name :").append(memcachedClientConfig.getName()));
            }
            this.cachepool.put(memcachedClientConfig.getName(), cache);
            Logger.info((Object)new StringBuilder().append(" add memcachedClient :").append(memcachedClientConfig.getName()));
        }
        for (MemcachedClientClusterConfig memcachedClientClusterConfig : this.memcachedClientClusterConfigs) {
            String[] clients = memcachedClientClusterConfig.getMemCachedClients();
            if (clients == null || clients.length <= 0) continue;
            MemcachedClientCluster cluster = new MemcachedClientCluster();
            cluster.setName(memcachedClientClusterConfig.getName());
            cluster.setMode(memcachedClientClusterConfig.getMode());
            cluster.setCaches(new ArrayList<IMemcachedCache>());
            for (String client : clients) {
                IMemcachedCache cache = this.cachepool.get(client);
                if (cache == null) continue;
                cluster.getCaches().add(cache);
                this.cache2cluster.put(cache, cluster);
            }
            if (this.clusterpool.get(cluster.getName()) != null) {
                Logger.error((Object)new StringBuilder("cluster define duplicate! cluster name :").append(cluster.getName()));
            }
            this.clusterpool.put(cluster.getName(), cluster);
        }
    }

    @Override
    public IMemcachedCache getCache(String name) {
        return this.getCachepool().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            block21: {
                try {
                    for (IMemcachedCache iMemcachedCache : this.getCachepool().values()) {
                        if (iMemcachedCache == null) continue;
                        iMemcachedCache.destroy();
                    }
                    if (this.socketpool == null || this.socketpool.size() <= 0) break block21;
                    Enumeration<String> keys = this.socketpool.keys();
                    while (keys.hasMoreElements()) {
                        String string = keys.nextElement();
                        SockIOPool.removeInstance(string);
                    }
                    this.socketpool.clear();
                }
                catch (Exception ex) {
                    Logger.error((Object)"Cache Manager Stop Error!", (Throwable)ex);
                    Object var4_7 = null;
                    this.getCachepool().clear();
                    if (this.clusterpool != null) {
                        this.clusterpool.clear();
                    }
                    if (this.cache2cluster != null) {
                        this.cache2cluster.clear();
                    }
                    if (this.memcachedClientconfigs != null) {
                        this.memcachedClientconfigs.clear();
                    }
                    if (this.memcachedClientSocketPoolConfigs != null) {
                        this.memcachedClientSocketPoolConfigs.clear();
                    }
                    if (this.memcachedClientClusterConfigs != null) {
                        this.memcachedClientClusterConfigs.clear();
                    }
                }
            }
            Object var4_6 = null;
            this.getCachepool().clear();
            if (this.clusterpool != null) {
                this.clusterpool.clear();
            }
            if (this.cache2cluster != null) {
                this.cache2cluster.clear();
            }
            if (this.memcachedClientconfigs != null) {
                this.memcachedClientconfigs.clear();
            }
            if (this.memcachedClientSocketPoolConfigs != null) {
                this.memcachedClientSocketPoolConfigs.clear();
            }
            if (this.memcachedClientClusterConfigs != null) {
                this.memcachedClientClusterConfigs.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.getCachepool().clear();
            if (this.clusterpool != null) {
                this.clusterpool.clear();
            }
            if (this.cache2cluster != null) {
                this.cache2cluster.clear();
            }
            if (this.memcachedClientconfigs != null) {
                this.memcachedClientconfigs.clear();
            }
            if (this.memcachedClientSocketPoolConfigs != null) {
                this.memcachedClientSocketPoolConfigs.clear();
            }
            if (this.memcachedClientClusterConfigs != null) {
                this.memcachedClientClusterConfigs.clear();
            }
            throw throwable;
        }
    }

    public ConcurrentHashMap<String, IMemcachedCache> getCachepool() {
        if (this.cachepool == null) {
            throw new RuntimeException("cachepool is null!");
        }
        return this.cachepool;
    }

    public ConcurrentHashMap<String, SockIOPool> getSocketpool() {
        return this.socketpool;
    }

    public void setSocketpool(ConcurrentHashMap<String, SockIOPool> socketpool) {
        this.socketpool = socketpool;
    }

    public boolean isSupportMultiConfig() {
        return this.supportMultiConfig;
    }

    public void setSupportMultiConfig(boolean supportMultiConfig) {
        this.supportMultiConfig = supportMultiConfig;
    }

    public ConcurrentHashMap<IMemcachedCache, MemcachedClientCluster> getCache2cluster() {
        return this.cache2cluster;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void reload(String configFile) {
        if (configFile != null && !configFile.equals("")) {
            this.configFile = configFile;
        }
        this.stop();
        this.start();
    }

    @Override
    public void clusterCopy(String fromCache, String cluster) {
        IMemcachedCache fcache = this.getCachepool().get(fromCache);
        MemcachedClientCluster t_cluster = this.clusterpool.get(cluster);
        if (fcache != null && t_cluster != null) {
            Set<String> keys = fcache.keySet(false);
            for (IMemcachedCache cache : t_cluster.getCaches()) {
                if (cache == fcache) continue;
                for (String key : keys) {
                    cache.put(key, fcache.get(key));
                }
            }
        }
    }

    @Override
    public void setResponseStatInterval(int seconds) {
        this.responseStatInterval = seconds;
    }
}

