/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.xplatform.asf.cache.memcached;

import com.alisoft.xplatform.asf.cache.ICache;
import com.alisoft.xplatform.asf.cache.IMemcachedCache;
import com.alisoft.xplatform.asf.cache.impl.DefaultCacheImpl;
import com.alisoft.xplatform.asf.cache.memcached.CacheCommand;
import com.alisoft.xplatform.asf.cache.memcached.ClusterProcessor;
import com.alisoft.xplatform.asf.cache.memcached.MemCachedClientHelper;
import com.alisoft.xplatform.asf.cache.memcached.MemcacheStats;
import com.alisoft.xplatform.asf.cache.memcached.MemcacheStatsSlab;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedException;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedResponse;
import com.alisoft.xplatform.asf.cache.memcached.client.MemCachedClient;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedCache
implements IMemcachedCache {
    private static final Log Logger = LogFactory.getLog(MemcachedCache.class);
    private MemCachedClientHelper helper;
    private ICache<String, Object> localCache;
    private ClusterProcessor processor;
    private StatisticsTask task;
    private long statisticsInterval = 300L;
    static final String CACHE_STATUS_RESPONSE = "cacheStatusResponse";
    private LinkedBlockingQueue<Object[]> dataQueue;

    public MemcachedCache(MemCachedClientHelper helper, int statisticsInterval) {
        this.helper = helper;
        this.dataQueue = new LinkedBlockingQueue();
        this.localCache = new DefaultCacheImpl();
        if (statisticsInterval > 0) {
            this.statisticsInterval = statisticsInterval;
            this.task = new StatisticsTask();
            this.task.setDaemon(true);
            this.task.start();
        }
        this.processor = new ClusterProcessor(this.dataQueue, helper);
        this.processor.setDaemon(true);
        this.processor.start();
    }

    @Override
    public boolean clear() {
        boolean result = false;
        if (this.helper.hasCluster()) {
            List<MemCachedClient> caches = this.helper.getClusterCache();
            for (MemCachedClient cache : caches) {
                try {
                    result = cache.flushAll(null);
                }
                catch (Exception ex) {
                    Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster clear error"), (Throwable)ex);
                    result = false;
                }
            }
            return result;
        }
        return this.helper.getInnerCacheClient().flushAll(null);
    }

    @Override
    public Map<String, Object> getMulti(String[] keys) {
        if (keys == null || keys.length <= 0) {
            return null;
        }
        Map<String, Object> result = this.getCacheClient(keys[0]).getMulti(keys);
        if (result != null) {
            return result;
        }
        if (this.helper.hasCluster()) {
            List<MemCachedClient> caches = this.helper.getClusterCache();
            for (MemCachedClient cache : caches) {
                if (this.getCacheClient(keys[0]).equals(cache)) continue;
                try {
                    result = cache.getMulti(keys);
                }
                catch (Exception ex) {
                    Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster getMulti error"), (Throwable)ex);
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public Object[] getMultiArray(String[] keys) {
        if (keys == null || keys.length <= 0) {
            return null;
        }
        Object[] result = this.getCacheClient(keys[0]).getMultiArray(keys);
        if (result != null) {
            return result;
        }
        if (this.helper.hasCluster()) {
            List<MemCachedClient> caches = this.helper.getClusterCache();
            for (MemCachedClient cache : caches) {
                if (this.getCacheClient(keys[0]).equals(cache)) continue;
                try {
                    result = cache.getMultiArray(keys);
                }
                catch (Exception ex) {
                    Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster getMultiArray error"), (Throwable)ex);
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public Object put(String key, Object value, Date expiry) {
        boolean result = this.getCacheClient(key).set(key, value, expiry);
        if (result) {
            this.localCache.remove(key);
        }
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.PUT, key, value, expiry};
            this.addCommandToQueue(commands);
        } else if (!result) {
            throw new RuntimeException("put key :" + key + " error!");
        }
        return value;
    }

    @Override
    public Object put(String key, Object value, int TTL) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, TTL);
        this.put(key, value, calendar.getTime());
        return value;
    }

    @Override
    public boolean containsKey(String key) {
        boolean result = false;
        boolean isError = false;
        try {
            result = this.getCacheClient(key).keyExists(key);
        }
        catch (MemcachedException ex) {
            Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster containsKey error"), (Throwable)ex);
            isError = true;
        }
        if (!result && this.helper.hasCluster() && (isError || this.helper.getClusterMode().equals("active"))) {
            List<MemCachedClient> caches = this.helper.getClusterCache();
            for (MemCachedClient cache : caches) {
                if (this.getCacheClient(key).equals(cache)) continue;
                try {
                    try {
                        result = cache.keyExists(key);
                    }
                    catch (MemcachedException ex) {
                        Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster containsKey error"), (Throwable)ex);
                        continue;
                    }
                    if (!this.helper.getClusterMode().equals("active") || !result) break;
                    Object[] commands = new Object[]{CacheCommand.RECOVER, key, cache.get(key)};
                    this.addCommandToQueue(commands);
                    break;
                }
                catch (Exception e) {
                    Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster get error"), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public Object get(String key) {
        Object result = null;
        boolean isError = false;
        try {
            result = this.getCacheClient(key).get(key);
        }
        catch (MemcachedException ex) {
            Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster get error"), (Throwable)ex);
            isError = true;
        }
        if (result == null && this.helper.hasCluster() && (isError || this.helper.getClusterMode().equals("active"))) {
            List<MemCachedClient> caches = this.helper.getClusterCache();
            for (MemCachedClient cache : caches) {
                if (this.getCacheClient(key).equals(cache)) continue;
                try {
                    try {
                        result = cache.get(key);
                    }
                    catch (MemcachedException ex) {
                        Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster get error"), (Throwable)ex);
                        continue;
                    }
                    if (!this.helper.getClusterMode().equals("active") || result == null) break;
                    Object[] commands = new Object[]{CacheCommand.RECOVER, key, result};
                    this.addCommandToQueue(commands);
                    break;
                }
                catch (Exception e) {
                    Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster get error"), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        boolean result = this.getCacheClient(key).set(key, value);
        if (result) {
            this.localCache.remove(key);
        }
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.PUT, key, value};
            this.addCommandToQueue(commands);
        } else if (!result) {
            throw new RuntimeException("put key :" + key + " error!");
        }
        return value;
    }

    @Override
    public void storeCounter(String key, long count) {
        boolean result = this.getCacheClient(key).storeCounter(key, count);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.STORECOUNTER, key, count};
            this.addCommandToQueue(commands);
        } else if (!result) {
            throw new RuntimeException("storeCounter key :" + key + " error!");
        }
    }

    @Override
    public long getCounter(String key) {
        long result = -1L;
        boolean isError = false;
        try {
            result = this.getCacheClient(key).getCounter(key);
        }
        catch (MemcachedException ex) {
            Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster getCounter error"), (Throwable)ex);
            isError = true;
        }
        if (result == -1L && this.helper.hasCluster() && (isError || this.helper.getClusterMode().equals("active"))) {
            List<MemCachedClient> caches = this.helper.getClusterCache();
            for (MemCachedClient cache : caches) {
                if (this.getCacheClient(key).equals(cache)) continue;
                try {
                    try {
                        result = cache.getCounter(key);
                    }
                    catch (MemcachedException ex) {
                        Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster getCounter error"), (Throwable)ex);
                        continue;
                    }
                    if (result == -1L || !this.helper.getClusterMode().equals("active")) break;
                    Object[] commands = new Object[]{CacheCommand.RECOVERCOUNTER, key, result};
                    this.addCommandToQueue(commands);
                    break;
                }
                catch (Exception e) {
                    Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster getCounter error"), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public long addOrDecr(String key, long decr) {
        long result = this.getCacheClient(key).addOrDecr(key, decr);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.ADDORDECR, key, decr};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public long addOrIncr(String key, long inc) {
        long result = this.getCacheClient(key).addOrIncr(key, inc);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.ADDORINCR, key, inc};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public long decr(String key, long decr) {
        long result = this.getCacheClient(key).decr(key, decr);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.DECR, key, decr};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public long incr(String key, long inc) {
        long result = this.getCacheClient(key).incr(key, inc);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.INCR, key, inc};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public Object remove(String key) {
        Boolean result = this.getCacheClient(key).delete(key);
        if (this.helper.hasCluster()) {
            List<MemCachedClient> caches = this.helper.getClusterCache();
            for (MemCachedClient cache : caches) {
                if (this.getCacheClient(key).equals(cache)) continue;
                try {
                    cache.delete(key);
                }
                catch (Exception ex) {
                    Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster remove error"), (Throwable)ex);
                }
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public int size() {
        throw new UnsupportedOperationException("Memcached not support size method!");
    }

    @Override
    public Collection<Object> values() {
        HashSet<Object> values = new HashSet<Object>();
        HashMap<String, Integer> dumps = new HashMap<String, Integer>();
        Map slabs = this.helper.getInnerCacheClient().statsItems();
        if (slabs != null && slabs.keySet() != null) {
            Iterator itemsItr = slabs.keySet().iterator();
            while (itemsItr.hasNext()) {
                String server = itemsItr.next().toString();
                Map itemNames = (Map)slabs.get(server);
                Iterator itemNameItr = itemNames.keySet().iterator();
                while (itemNameItr.hasNext()) {
                    String itemName = itemNameItr.next().toString();
                    String[] itemAtt = itemName.split(":");
                    if (!itemAtt[2].startsWith("number")) continue;
                    dumps.put(itemAtt[1], Integer.parseInt(itemAtt[1]));
                }
            }
            if (!dumps.values().isEmpty()) {
                Iterator dumpIter = dumps.values().iterator();
                while (dumpIter.hasNext()) {
                    int dump = (Integer)dumpIter.next();
                    Map cacheDump = this.helper.getInnerCacheClient().statsCacheDump(dump, 50000);
                    for (Map items : cacheDump.values()) {
                        for (String k : items.keySet()) {
                            Object value;
                            try {
                                k = URLDecoder.decode(k, "UTF-8");
                            }
                            catch (Exception ex) {
                                Logger.error((Object)ex);
                            }
                            if (k == null || k.trim().equals("") || (value = this.get(k)) == null) continue;
                            values.add(value);
                        }
                    }
                }
            }
        }
        return values;
    }

    @Override
    public Set<String> keySet(boolean fast) {
        HashSet<String> keys = new HashSet<String>();
        HashMap<String, Integer> dumps = new HashMap<String, Integer>();
        Map slabs = this.helper.getInnerCacheClient().statsItems();
        if (slabs != null && slabs.keySet() != null) {
            Iterator itemsItr = slabs.keySet().iterator();
            while (itemsItr.hasNext()) {
                String server = itemsItr.next().toString();
                Map itemNames = (Map)slabs.get(server);
                Iterator itemNameItr = itemNames.keySet().iterator();
                while (itemNameItr.hasNext()) {
                    String itemName = itemNameItr.next().toString();
                    String[] itemAtt = itemName.split(":");
                    if (!itemAtt[2].startsWith("number")) continue;
                    dumps.put(itemAtt[1], Integer.parseInt(itemAtt[1]));
                }
            }
            if (!dumps.values().isEmpty()) {
                Iterator dumpIter = dumps.values().iterator();
                while (dumpIter.hasNext()) {
                    int dump = (Integer)dumpIter.next();
                    Map cacheDump = this.helper.getInnerCacheClient().statsCacheDump(dump, 0);
                    for (Map items : cacheDump.values()) {
                        for (String k : items.keySet()) {
                            try {
                                k = URLDecoder.decode(k, "UTF-8");
                            }
                            catch (Exception ex) {
                                Logger.error((Object)ex);
                            }
                            if (k == null || k.trim().equals("")) continue;
                            if (fast) {
                                keys.add(k);
                                continue;
                            }
                            if (!this.containsKey(k)) continue;
                            keys.add(k);
                        }
                    }
                }
            }
        }
        return keys;
    }

    public MemCachedClient getCacheClient(String key) {
        if (this.helper == null) {
            Logger.error((Object)"MemcachedCache helper is null!");
            throw new RuntimeException("MemcachedCache helper is null!");
        }
        return this.helper.getCacheClient(key);
    }

    public MemCachedClientHelper getHelper() {
        return this.helper;
    }

    public void setHelper(MemCachedClientHelper helper) {
        this.helper = helper;
    }

    @Override
    public Set<String> keySet() {
        return this.keySet(false);
    }

    @Override
    public Object get(String key, int localTTL) {
        Object result = null;
        result = this.localCache.get(key);
        if (result == null && (result = this.get(key)) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, localTTL);
            this.localCache.put(key, result, calendar.getTime());
        }
        return result;
    }

    @Override
    public MemcacheStats[] stats() {
        MemcacheStats[] result = null;
        Map statMap = this.helper.getInnerCacheClient().stats();
        if (statMap != null && !statMap.isEmpty()) {
            result = new MemcacheStats[statMap.size()];
            Iterator iter = statMap.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                result[i] = new MemcacheStats();
                result[i].setServerHost((String)iter.next());
                result[i].setStatInfo(((Map)statMap.get(result[i].getServerHost())).toString());
                ++i;
            }
        }
        return result;
    }

    @Override
    public MemcacheStatsSlab[] statsSlabs() {
        MemcacheStatsSlab[] result = null;
        Map statMap = this.helper.getInnerCacheClient().statsSlabs();
        if (statMap != null && !statMap.isEmpty()) {
            result = new MemcacheStatsSlab[statMap.size()];
            Iterator iter = statMap.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                result[i] = new MemcacheStatsSlab();
                result[i].setServerHost((String)iter.next());
                Map node = (Map)statMap.get(result[i].getServerHost());
                for (String key : node.keySet()) {
                    result[i].addSlab(key, node.get(key).toString());
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public Map statsItems() {
        Map items = this.helper.getInnerCacheClient().statsItems();
        return items;
    }

    public void addCommandToQueue(Object[] command) {
        this.dataQueue.add(command);
    }

    @Override
    public void destroy() {
        try {
            if (this.localCache != null) {
                this.localCache.destroy();
            }
            if (this.processor != null) {
                this.processor.stopProcess();
            }
            if (this.task != null) {
                this.task.stopTask();
            }
        }
        catch (Exception ex) {
            Logger.error((Object)ex);
        }
    }

    @Override
    public MemcachedResponse statCacheResponse() {
        if (this.localCache.get(CACHE_STATUS_RESPONSE) == null) {
            MemcachedResponse response = new MemcachedResponse();
            response.setCacheName(this.helper.getCacheName());
            this.localCache.put(CACHE_STATUS_RESPONSE, response);
        }
        return (MemcachedResponse)this.localCache.get(CACHE_STATUS_RESPONSE);
    }

    public long getStatisticsInterval() {
        return this.statisticsInterval;
    }

    @Override
    public void setStatisticsInterval(long statisticsInterval) {
        this.statisticsInterval = statisticsInterval;
    }

    @Override
    public boolean add(String key, Object value) {
        boolean result = this.getCacheClient(key).add(key, value);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.ADD, key, value};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public boolean add(String key, Object value, Date expiry) {
        boolean result = this.getCacheClient(key).add(key, value, expiry);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.ADD, key, value, expiry};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public boolean replace(String key, Object value) {
        boolean result = this.getCacheClient(key).replace(key, value);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.REPLACE, key, value};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public boolean replace(String key, Object value, Date expiry) {
        boolean result = this.getCacheClient(key).replace(key, value, expiry);
        if (this.helper.hasCluster()) {
            Object[] commands = new Object[]{CacheCommand.REPLACE, key, value, expiry};
            this.addCommandToQueue(commands);
        }
        return result;
    }

    @Override
    public void asynPut(String key, Object value) {
        Object[] commands = new Object[]{CacheCommand.ANSYPUT, key, value};
        this.addCommandToQueue(commands);
    }

    @Override
    public void asynAddOrDecr(String key, long decr) {
        Object[] commands = new Object[]{CacheCommand.ANSYADDORDECR, key, decr};
        this.addCommandToQueue(commands);
    }

    @Override
    public void asynAddOrIncr(String key, long incr) {
        Object[] commands = new Object[]{CacheCommand.ANSYADDORINCR, key, incr};
        this.addCommandToQueue(commands);
    }

    @Override
    public void asynDecr(String key, long decr) {
        Object[] commands = new Object[]{CacheCommand.ANSYDECR, key, decr};
        this.addCommandToQueue(commands);
    }

    @Override
    public void asynIncr(String key, long incr) {
        Object[] commands = new Object[]{CacheCommand.ANSYINCR, key, incr};
        this.addCommandToQueue(commands);
    }

    @Override
    public void asynStoreCounter(String key, long count) {
        Object[] commands = new Object[]{CacheCommand.ANSYSTORECOUNTER, key, count};
        this.addCommandToQueue(commands);
    }

    class StatisticsTask
    extends Thread {
        private boolean flag = true;

        StatisticsTask() {
        }

        public void run() {
            while (this.flag) {
                MemcachedResponse response;
                long consume = 0L;
                try {
                    Thread.sleep(MemcachedCache.this.statisticsInterval * 1000L);
                    consume = this.checkResponse();
                }
                catch (InterruptedException e) {
                    Logger.warn((Object)"StatisticsTask stoped!");
                }
                catch (Exception ex) {
                    Logger.error((Object)"StatisticsTask execute error", (Throwable)ex);
                    consume = -1L;
                }
                if (MemcachedCache.this.localCache == null || (response = (MemcachedResponse)MemcachedCache.this.localCache.get(MemcachedCache.CACHE_STATUS_RESPONSE)) == null || response.getResponses() == null) continue;
                response.getResponses().add(consume);
            }
        }

        private long checkResponse() {
            if (MemcachedCache.this.localCache.get(MemcachedCache.CACHE_STATUS_RESPONSE) == null) {
                MemcachedResponse response = new MemcachedResponse();
                response.setCacheName(MemcachedCache.this.helper.getCacheName());
                MemcachedCache.this.localCache.put(MemcachedCache.CACHE_STATUS_RESPONSE, response);
            } else if (((MemcachedResponse)MemcachedCache.this.localCache.get(MemcachedCache.CACHE_STATUS_RESPONSE)).getEndTime().before(new Date())) {
                ((MemcachedResponse)MemcachedCache.this.localCache.get(MemcachedCache.CACHE_STATUS_RESPONSE)).ini();
            }
            long consume = System.currentTimeMillis();
            MemcachedCache.this.put(MemcachedCache.CACHE_STATUS_RESPONSE, (Object)MemcachedCache.CACHE_STATUS_RESPONSE);
            MemcachedCache.this.get(MemcachedCache.CACHE_STATUS_RESPONSE);
            consume = System.currentTimeMillis() - consume;
            return consume;
        }

        public void stopTask() {
            this.flag = false;
            this.interrupt();
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }
}

