/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.xplatform.asf.cache.memcached;

import com.alisoft.xplatform.asf.cache.IMemcachedCache;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedCache;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedCacheManager;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientCluster;
import com.alisoft.xplatform.asf.cache.memcached.client.MemCachedClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemCachedClientHelper {
    private static final Log Logger = LogFactory.getLog(MemCachedClientHelper.class);
    private MemCachedClient cacheClient;
    private MemcachedCacheManager cacheManager;
    private IMemcachedCache memcachedCache;
    private String cacheName;

    public List<MemCachedClient> getClusterCache() {
        ArrayList<MemCachedClient> result = new ArrayList<MemCachedClient>();
        if (this.hasCluster()) {
            MemcachedClientCluster cluster = this.cacheManager.getCache2cluster().get(this.memcachedCache);
            for (IMemcachedCache node : cluster.getCaches()) {
                if (!(node instanceof MemcachedCache)) continue;
                result.add(((MemcachedCache)node).getHelper().getInnerCacheClient());
            }
        }
        return result;
    }

    protected boolean hasCluster() {
        MemcachedClientCluster cluster;
        boolean result = false;
        if (this.memcachedCache != null && this.cacheManager != null && (cluster = this.cacheManager.getCache2cluster().get(this.memcachedCache)) != null && cluster.getCaches() != null && cluster.getCaches().size() > 0) {
            result = true;
        }
        return result;
    }

    protected String getClusterMode() {
        MemcachedClientCluster cluster;
        String mode = "none";
        if (this.memcachedCache != null && this.cacheManager != null && (cluster = this.cacheManager.getCache2cluster().get(this.memcachedCache)) != null && cluster.getCaches() != null && cluster.getCaches().size() > 0 && (cluster.getMode().equals("active") || cluster.getMode().equals("standby"))) {
            mode = cluster.getMode();
        }
        return mode;
    }

    public MemCachedClient getInnerCacheClient() {
        if (this.cacheClient == null) {
            Logger.error((Object)"cacheClient can't be injected into MemcachedCacheHelper");
            throw new RuntimeException("cacheClient can't be injected into MemcachedCacheHelper");
        }
        return this.cacheClient;
    }

    public MemCachedClient getCacheClient(String key) {
        if (this.cacheClient == null) {
            Logger.error((Object)"cacheClient can't be injected into MemcachedCacheHelper");
            throw new RuntimeException("cacheClient can't be injected into MemcachedCacheHelper");
        }
        if (this.hasCluster()) {
            List<MemCachedClient> clusters = this.getClusterCache();
            long keyhash = key.hashCode();
            int index = (int)keyhash % clusters.size();
            if (index < 0) {
                index *= -1;
            }
            return clusters.get(index);
        }
        return this.cacheClient;
    }

    public void setCacheClient(MemCachedClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public MemcachedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(MemcachedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public IMemcachedCache getMemcachedCache() {
        return this.memcachedCache;
    }

    public void setMemcachedCache(IMemcachedCache memcachedCache) {
        this.memcachedCache = memcachedCache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }
}

