/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.xplatform.asf.cache.memcached;

import com.alisoft.xplatform.asf.cache.memcached.CacheCommand;
import com.alisoft.xplatform.asf.cache.memcached.MemCachedClientHelper;
import com.alisoft.xplatform.asf.cache.memcached.client.MemCachedClient;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterProcessor
extends Thread {
    private static final Log Logger = LogFactory.getLog(ClusterProcessor.class);
    LinkedBlockingQueue<Object[]> queue;
    MemCachedClientHelper helper;
    boolean isRunning = true;
    private ExecutorService clusterProcessorPool;

    public ClusterProcessor(LinkedBlockingQueue<Object[]> queue, MemCachedClientHelper helper) {
        this.queue = queue;
        this.helper = helper;
        this.clusterProcessorPool = Executors.newFixedThreadPool(30);
    }

    @Override
    public void run() {
        while (this.isRunning) {
            this.process();
        }
    }

    public void stopProcess() {
        this.isRunning = false;
        try {
            if (this.clusterProcessorPool != null) {
                this.clusterProcessorPool.shutdown();
            }
            this.clusterProcessorPool = null;
            this.interrupt();
        }
        catch (Exception ex) {
            Logger.error((Object)ex);
        }
    }

    void process() {
        Object[] commands = null;
        try {
            commands = this.queue.take();
            if (commands != null && this.clusterProcessorPool != null) {
                this.clusterProcessorPool.execute(new ClusterUpdateJob(commands));
            }
        }
        catch (InterruptedException e) {
            Logger.warn((Object)"cluster Process stoped!");
        }
        catch (Exception ex) {
            Logger.error((Object)"cluster Process error!", (Throwable)ex);
        }
    }

    public boolean ansyCommandProcess(Object[] commands) {
        boolean result = false;
        MemCachedClient innerCache = this.helper.getInnerCacheClient();
        switch ((CacheCommand)((Object)commands[0])) {
            case ANSYPUT: {
                innerCache.set(commands[1].toString(), commands[2]);
                result = true;
                break;
            }
            case ANSYSTORECOUNTER: {
                innerCache.storeCounter(commands[1].toString(), (Long)commands[2]);
                result = true;
                break;
            }
            case ANSYADDORDECR: {
                innerCache.addOrDecr(commands[1].toString(), (Long)commands[2]);
                result = true;
                break;
            }
            case ANSYADDORINCR: {
                innerCache.addOrIncr(commands[1].toString(), (Long)commands[2]);
                result = true;
                break;
            }
            case ANSYDECR: {
                innerCache.decr(commands[1].toString(), (Long)commands[2]);
                result = true;
                break;
            }
            case ANSYINCR: {
                innerCache.incr(commands[1].toString(), (Long)commands[2]);
                result = true;
            }
        }
        return result;
    }

    public void commandProcess(Object[] commands) {
        List<MemCachedClient> caches = this.helper.getClusterCache();
        for (MemCachedClient cache : caches) {
            if (commands[0] == CacheCommand.RECOVER || commands[0] == CacheCommand.RECOVERCOUNTER) {
                if (!this.helper.getCacheClient(commands[1].toString()).equals(cache)) continue;
                if (commands[0] == CacheCommand.RECOVER) {
                    cache.set(commands[1].toString(), commands[2]);
                    break;
                }
                cache.storeCounter(commands[1].toString(), (Long)commands[2]);
                break;
            }
            if (this.helper.getCacheClient(commands[1].toString()).equals(cache)) continue;
            try {
                switch ((CacheCommand)((Object)commands[0])) {
                    case ANSYPUT: 
                    case PUT: {
                        if (commands.length > 3) {
                            cache.set(commands[1].toString(), commands[2], (Date)commands[3]);
                            break;
                        }
                        cache.set(commands[1].toString(), commands[2]);
                        break;
                    }
                    case ADD: {
                        if (commands.length > 3) {
                            cache.add(commands[1].toString(), commands[2], (Date)commands[3]);
                            break;
                        }
                        cache.add(commands[1].toString(), commands[2]);
                        break;
                    }
                    case REPLACE: {
                        if (commands.length > 3) {
                            cache.replace(commands[1].toString(), commands[2], (Date)commands[3]);
                            break;
                        }
                        cache.replace(commands[1].toString(), commands[2]);
                        break;
                    }
                    case ANSYSTORECOUNTER: 
                    case STORECOUNTER: {
                        cache.storeCounter(commands[1].toString(), (Long)commands[2]);
                        break;
                    }
                    case ANSYADDORDECR: 
                    case ADDORDECR: {
                        cache.addOrDecr(commands[1].toString(), (Long)commands[2]);
                        break;
                    }
                    case ANSYADDORINCR: 
                    case ADDORINCR: {
                        cache.addOrIncr(commands[1].toString(), (Long)commands[2]);
                        break;
                    }
                    case ANSYINCR: 
                    case INCR: {
                        cache.incr(commands[1].toString(), (Long)commands[2]);
                        break;
                    }
                    case ANSYDECR: 
                    case DECR: {
                        cache.decr(commands[1].toString(), (Long)commands[2]);
                    }
                }
            }
            catch (Exception ex) {
                Logger.error((Object)new StringBuilder(this.helper.getCacheName()).append(" cluster process error"), (Throwable)ex);
            }
        }
    }

    class ClusterUpdateJob
    implements Runnable {
        Object[] commands;

        public ClusterUpdateJob(Object[] commands) {
            this.commands = commands;
        }

        public void run() {
            if (this.commands != null) {
                if (ClusterProcessor.this.ansyCommandProcess(this.commands) && !ClusterProcessor.this.helper.hasCluster()) {
                    return;
                }
                ClusterProcessor.this.commandProcess(this.commands);
            }
        }
    }
}

