/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.xplatform.asf.cache.memcached;

import com.alisoft.xplatform.asf.cache.ICache;
import com.alisoft.xplatform.asf.cache.ICacheManager;
import com.alisoft.xplatform.asf.cache.impl.DefaultCacheImpl;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientClusterConfig;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientConfig;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedClientSocketPoolConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheUtil {
    private static final Log Logger = LogFactory.getLog(CacheUtil.class);
    private static ICache<String, Object> localCache = new DefaultCacheImpl();

    public static <B extends ICache<?, ?>> ICacheManager<B> getCacheManager(Class<B> cache, String defaultImplClass) {
        ICacheManager cacheManager = null;
        cacheManager = CacheUtil.getInstanceByInterface(ICacheManager.class, Thread.currentThread().getContextClassLoader(), defaultImplClass, true);
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I> I getInstanceByInterface(Class<I> interfaceDefinition, ClassLoader classLoader, String defaultImplClass, boolean needCache) {
        Object result = null;
        if (needCache) {
            String className = (String)localCache.get(interfaceDefinition.getName());
            if (className != null && !className.equals("")) {
                return CacheUtil.newInstance(interfaceDefinition, className, classLoader);
            }
        } else {
            localCache.remove(interfaceDefinition.getName());
        }
        String errorStr = interfaceDefinition.getName() + " Instance load error!";
        try {
            String systemProp = System.getProperty(interfaceDefinition.getName());
            if (systemProp != null) {
                Logger.info((Object)("found system property" + systemProp));
                if (needCache) {
                    localCache.put(interfaceDefinition.getName(), systemProp);
                }
                return CacheUtil.newInstance(interfaceDefinition, systemProp, classLoader);
            }
        }
        catch (Exception ex) {
            Logger.error((Object)errorStr, (Throwable)ex);
            result = null;
        }
        String serviceId = "META-INF/services/" + interfaceDefinition.getName();
        InputStream in = null;
        try {
            in = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (in != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String className = rd.readLine();
                rd.close();
                if (className != null && !"".equals(className)) {
                    Logger.info((Object)("loaded from services: " + className));
                    if (needCache) {
                        localCache.put(interfaceDefinition.getName(), className);
                    }
                    I i = CacheUtil.newInstance(interfaceDefinition, className, classLoader);
                    return i;
                }
            } else if (defaultImplClass != null && !defaultImplClass.equals("")) {
                Logger.info((Object)("loaded from services: " + defaultImplClass));
                if (needCache) {
                    localCache.put(interfaceDefinition.getName(), defaultImplClass);
                }
                I rd = CacheUtil.newInstance(interfaceDefinition, defaultImplClass, classLoader);
                return rd;
            }
        }
        catch (Exception ex) {
            Logger.error((Object)errorStr, (Throwable)ex);
            result = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                in = null;
            }
            catch (Exception ex) {
                Logger.error((Object)errorStr, (Throwable)ex);
                result = null;
            }
        }
        if (result == null) {
            throw new RuntimeException(errorStr);
        }
        return result;
    }

    private static <I> I newInstance(Class<I> interfaceDefinition, String className, ClassLoader classLoader) {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return (I)spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new RuntimeException("Provider " + className + " not found", x);
        }
        catch (Exception ex) {
            throw new RuntimeException("Provider " + className + " could not be instantiated: " + ex, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMemcachedConfigFromURL(URL url, XMLInputFactory factory, List<MemcachedClientConfig> memcachedClientconfigs, List<MemcachedClientSocketPoolConfig> memcachedClientSocketPoolConfigs, List<MemcachedClientClusterConfig> memcachedClientClusterConfig) {
        MemcachedClientConfig node = null;
        MemcachedClientSocketPoolConfig socketnode = null;
        MemcachedClientClusterConfig clusternode = null;
        InputStream in = null;
        XMLEventReader r = null;
        try {
            in = url.openStream();
            r = factory.createXMLEventReader(in);
            String servers = null;
            String weights = null;
            while (r.hasNext()) {
                XMLEvent event = r.nextEvent();
                if (event.isStartElement()) {
                    StartElement start = event.asStartElement();
                    String tag = start.getName().getLocalPart();
                    if (tag.equalsIgnoreCase("client")) {
                        node = new MemcachedClientConfig();
                        if (start.getAttributeByName(new QName("", "name")) == null) {
                            throw new RuntimeException("memcached client name can't not be null!");
                        }
                        node.setName(start.getAttributeByName(new QName("", "name")).getValue());
                        if (start.getAttributeByName(new QName("", "socketpool")) == null) {
                            throw new RuntimeException("memcached client socketpool can't not be null!");
                        }
                        node.setSocketPool(start.getAttributeByName(new QName("", "socketpool")).getValue());
                        if (start.getAttributeByName(new QName("", "compressEnable")) != null) {
                            node.setCompressEnable(Boolean.parseBoolean(start.getAttributeByName(new QName("", "compressEnable")).getValue()));
                        } else {
                            node.setCompressEnable(true);
                        }
                        if (start.getAttributeByName(new QName("", "defaultEncoding")) != null) {
                            node.setDefaultEncoding(start.getAttributeByName(new QName("", "defaultEncoding")).getValue());
                            continue;
                        }
                        node.setDefaultEncoding("UTF-8");
                        continue;
                    }
                    if (tag.equalsIgnoreCase("errorHandler") && node != null) {
                        event = r.peek();
                        if (!event.isCharacters()) continue;
                        node.setErrorHandler(event.asCharacters().getData());
                        r.nextEvent();
                        continue;
                    }
                    if (tag.equalsIgnoreCase("socketpool")) {
                        socketnode = new MemcachedClientSocketPoolConfig();
                        servers = null;
                        weights = null;
                        if (start.getAttributeByName(new QName("", "name")) == null) {
                            throw new RuntimeException("memcached client socketpool name can't not be null!");
                        }
                        socketnode.setName(start.getAttributeByName(new QName("", "name")).getValue());
                        if (start.getAttributeByName(new QName("", "failover")) != null) {
                            socketnode.setFailover(Boolean.parseBoolean(start.getAttributeByName(new QName("", "failover")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "initConn")) != null) {
                            socketnode.setInitConn(Integer.parseInt(start.getAttributeByName(new QName("", "initConn")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "minConn")) != null) {
                            socketnode.setMinConn(Integer.parseInt(start.getAttributeByName(new QName("", "minConn")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "maxConn")) != null) {
                            socketnode.setMaxConn(Integer.parseInt(start.getAttributeByName(new QName("", "maxConn")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "maintSleep")) != null) {
                            socketnode.setMaintSleep(Integer.parseInt(start.getAttributeByName(new QName("", "maintSleep")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "nagle")) != null) {
                            socketnode.setNagle(Boolean.parseBoolean(start.getAttributeByName(new QName("", "nagle")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "socketTO")) != null) {
                            socketnode.setSocketTo(Integer.parseInt(start.getAttributeByName(new QName("", "socketTO")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "maxIdle")) != null) {
                            socketnode.setMaxIdle(Integer.parseInt(start.getAttributeByName(new QName("", "maxIdle")).getValue()));
                        }
                        if (start.getAttributeByName(new QName("", "aliveCheck")) == null) continue;
                        socketnode.setAliveCheck(Boolean.parseBoolean(start.getAttributeByName(new QName("", "aliveCheck")).getValue()));
                        continue;
                    }
                    if (tag.equalsIgnoreCase("servers") && socketnode != null) {
                        event = r.peek();
                        if (!event.isCharacters()) continue;
                        servers = event.asCharacters().getData();
                        socketnode.setServers(servers);
                        r.nextEvent();
                        continue;
                    }
                    if (tag.equalsIgnoreCase("weights") && socketnode != null) {
                        event = r.peek();
                        if (!event.isCharacters()) continue;
                        weights = event.asCharacters().getData();
                        socketnode.setWeights(weights);
                        r.nextEvent();
                        continue;
                    }
                    if (tag.equalsIgnoreCase("cluster")) {
                        clusternode = new MemcachedClientClusterConfig();
                        if (start.getAttributeByName(new QName("", "name")) == null) {
                            throw new RuntimeException("memcached cluster name can't not be null!");
                        }
                        clusternode.setName(start.getAttributeByName(new QName("", "name")).getValue());
                        if (start.getAttributeByName(new QName("", "mode")) == null) continue;
                        clusternode.setMode(start.getAttributeByName(new QName("", "mode")).getValue());
                        continue;
                    }
                    if (tag.equalsIgnoreCase("memCachedClients") && clusternode != null) {
                        event = r.peek();
                        if (!event.isCharacters()) continue;
                        String clients = event.asCharacters().getData();
                        if (clients != null && !clients.equals("")) {
                            clusternode.setMemCachedClients(clients.split(","));
                        }
                        r.nextEvent();
                        continue;
                    }
                }
                if (!event.isEndElement()) continue;
                EndElement end = event.asEndElement();
                if (node != null && end.getName().getLocalPart().equalsIgnoreCase("client")) {
                    memcachedClientconfigs.add(node);
                    Logger.info((Object)new StringBuilder().append(" add memcachedClient config :").append(node.getName()));
                    continue;
                }
                if (socketnode != null && end.getName().getLocalPart().equalsIgnoreCase("socketpool")) {
                    memcachedClientSocketPoolConfigs.add(socketnode);
                    Logger.info((Object)new StringBuilder().append(" add socketpool config :").append(socketnode.getName()));
                    continue;
                }
                if (clusternode == null || !end.getName().getLocalPart().equalsIgnoreCase("cluster")) continue;
                memcachedClientClusterConfig.add(clusternode);
                Logger.info((Object)new StringBuilder().append(" add cluster config :").append(clusternode.getName()));
            }
        }
        catch (Exception e) {
            Logger.error((Object)("MemcachedManager loadConfig error !" + " config url :" + url.getFile()));
            node = null;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
                r = null;
                in = null;
            }
            catch (Exception ex) {
                throw new RuntimeException("processConfigURL error !", ex);
            }
        }
    }
}

