/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.xplatform.asf.cache.impl;

import com.alisoft.xplatform.asf.cache.ICache;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheImpl
implements ICache<String, Object> {
    private static final Log Logger = LogFactory.getLog(DefaultCacheImpl.class);
    ConcurrentHashMap<String, Object>[] caches;
    ConcurrentHashMap<String, Long> expiryCache;
    private ScheduledExecutorService scheduleService;
    private int expiryInterval = 10;
    private int moduleSize = 10;

    public DefaultCacheImpl() {
        this.init();
    }

    public DefaultCacheImpl(int expiryInterval, int moduleSize) {
        this.expiryInterval = expiryInterval;
        this.moduleSize = moduleSize;
        this.init();
    }

    private void init() {
        this.caches = new ConcurrentHashMap[this.moduleSize];
        for (int i = 0; i < this.moduleSize; ++i) {
            this.caches[i] = new ConcurrentHashMap();
        }
        this.expiryCache = new ConcurrentHashMap();
        this.scheduleService = Executors.newScheduledThreadPool(1);
        this.scheduleService.scheduleAtFixedRate(new CheckOutOfDateSchedule(this.caches, this.expiryCache), 0L, this.expiryInterval * 60, TimeUnit.SECONDS);
        if (Logger.isInfoEnabled()) {
            Logger.info((Object)"DefaultCache CheckService is start!");
        }
    }

    @Override
    public boolean clear() {
        if (this.caches != null) {
            for (ConcurrentHashMap<String, Object> cache : this.caches) {
                cache.clear();
            }
        }
        if (this.expiryCache != null) {
            this.expiryCache.clear();
        }
        return true;
    }

    @Override
    public boolean containsKey(String key) {
        this.checkValidate(key);
        return this.getCache(key).containsKey(key);
    }

    @Override
    public Object get(String key) {
        this.checkValidate(key);
        return this.getCache(key).get(key);
    }

    @Override
    public Set<String> keySet() {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        Object result = this.getCache(key).put(key, value);
        this.expiryCache.put(key, -1L);
        return result;
    }

    @Override
    public Object put(String key, Object value, Date expiry) {
        Object result = this.getCache(key).put(key, value);
        this.expiryCache.put(key, expiry.getTime());
        return result;
    }

    @Override
    public Object remove(String key) {
        Object result = this.getCache(key).remove(key);
        this.expiryCache.remove(key);
        return result;
    }

    @Override
    public int size() {
        this.checkAll();
        return this.expiryCache.size();
    }

    @Override
    public Collection<Object> values() {
        this.checkAll();
        ArrayList<Object> values = new ArrayList<Object>();
        for (ConcurrentHashMap<String, Object> cache : this.caches) {
            values.addAll(cache.values());
        }
        return values;
    }

    private ConcurrentHashMap<String, Object> getCache(String key) {
        long hashCode = key.hashCode();
        if (hashCode < 0L) {
            hashCode = -hashCode;
        }
        int moudleNum = (int)hashCode % this.moduleSize;
        return this.caches[moudleNum];
    }

    private void checkValidate(String key) {
        if (this.expiryCache.get(key) != null && this.expiryCache.get(key) != -1L && new Date(this.expiryCache.get(key)).before(new Date())) {
            this.getCache(key).remove(key);
            this.expiryCache.remove(key);
        }
    }

    private void checkAll() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidate(key);
        }
    }

    @Override
    public Object put(String key, Object value, int TTL) {
        Object result = this.getCache(key).put(key, value);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, TTL);
        this.expiryCache.put(key, calendar.getTime().getTime());
        return result;
    }

    @Override
    public void destroy() {
        try {
            this.clear();
            if (this.scheduleService != null) {
                this.scheduleService.shutdown();
            }
            this.scheduleService = null;
        }
        catch (Exception ex) {
            Logger.error((Object)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckOutOfDateSchedule
    implements Runnable {
        ConcurrentHashMap<String, Object>[] caches;
        ConcurrentHashMap<String, Long> expiryCache;

        public CheckOutOfDateSchedule(ConcurrentHashMap<String, Object>[] caches, ConcurrentHashMap<String, Long> expiryCache) {
            this.caches = caches;
            this.expiryCache = expiryCache;
        }

        @Override
        public void run() {
            this.check();
        }

        public void check() {
            try {
                for (ConcurrentHashMap<String, Object> cache : this.caches) {
                    for (String key : cache.keySet()) {
                        long date;
                        if (this.expiryCache.get(key) == null || (date = this.expiryCache.get(key).longValue()) <= 0L || !new Date(date).before(new Date())) continue;
                        this.expiryCache.remove(key);
                        cache.remove(key);
                    }
                }
            }
            catch (Exception ex) {
                Logger.info((Object)"DefaultCache CheckService is start!");
            }
        }
    }
}

