/**
 * 
 */
package com.alisoft.xplatform.asf.cache;

import java.util.Date;
import java.util.Map;
import java.util.Set;

import com.alisoft.xplatform.asf.cache.memcached.MemcacheStats;
import com.alisoft.xplatform.asf.cache.memcached.MemcacheStatsSlab;
import com.alisoft.xplatform.asf.cache.memcached.MemcachedResponse;

/**
 * Memcached CacheĽӿڶ
 * @author wenchu.cenwc<wenchu.cenwc@alibaba-inc.com>
 *
 */
public interface IMemcachedCache extends ICache<String,Object>
{

	/**
	 * memcacheĽƵɵʧ˲ñcachememcacheķʽ
	 * @param key
	 * @param ػʧЧʱ䵥λ
	 * @return
	 */
	public Object get(String key,int localTTL);
	
	/**
	 * ȡkeysӦֵ
	 * @param keys
	 * @return
	 */
	public Object[] getMultiArray(String[] keys);
	/**
	 * ȡkeysӦkey&value Entrys
	 * @param keys
	 * @return
	 */
	public Map<String,Object> getMulti(String[] keys);
	
	
	/**
	 * keyӦһʵinc
	 * @param key
	 * @param inc
	 * @return
	 */
	public long incr(String key,long inc);
	
	/**
	 * keyӦһʵּdecr
	 * @param key
	 * @param decr
	 * @return
	 */
	public long decr(String key,long decr);
	
	/**
	 * keyӦһʵinc
	 * @param key
	 * @param inc
	 * @return
	 */
	public long addOrIncr(String key,long inc);
	
	/**
	 * keyӦһʵּdecr
	 * @param key
	 * @param decr
	 * @return
	 */
	public long addOrDecr(String key,long decr);
	
	/**
	 * 洢
	 * @param key
	 * @param count
	 */
	public void storeCounter(String key,long count); 
	
	/**
	 * ȡĴ-1ʾ
	 * @param key
	 */
	public long getCounter(String key);
	
	
	/**
	 * ӿڷصKeyfastģʽ
	 * ôصkeyѾʧЧڴлкۼǷfastģʽôͻᾫȷأЧʽϵ
	 * @param ǷҪȥkeyǷ
	 * @return
	 */
	public Set<String> keySet(boolean fast);
	
	
	/**
	 * ͳƷSlab
	 * @return
	 */
	public MemcacheStatsSlab[] statsSlabs();
	
	
	/**
	 * ͳMemcacheʹõ
	 * @return
	 */
	public MemcacheStats[] stats();
	
	/**
	 * ͳItemsĴ洢
	 * @param servers
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Map statsItems();
	
	/**
	 * ͳCacheӦʱ
	 * @return
	 */
	public MemcachedResponse statCacheResponse();
	
	/**
	 * ͳʱ䣬λΪ
	 * @param checkInterval
	 */
	public void setStatisticsInterval(long checkInterval);
	
	
	/**
	 * ,ǰkeymemcacheУ򱣴治ɹ
	 * @param key
	 * @param value
	 * @return
	 */
	public boolean add(String key,Object value);	
	
	/**
	 * ЧڵݣǰkeymemcacheУ򱣴治ɹ
	 * @param key
	 * @param value
	 * @param Ч
	 * @return
	 */
	public boolean add(String key,Object value, Date expiry);
	
	
	/**
	 * ,ǰkeymemcacheУ򱣴治ɹ
	 * @param key
	 * @param value
	 * @return
	 */
	public boolean replace(String key,Object value);	
	
	/**
	 * ЧڵݣǰkeymemcacheУ򱣴治ɹ
	 * @param key
	 * @param value
	 * @param Ч
	 * @return
	 */
	public boolean replace(String key,Object value, Date expiry);	
	
	/**
	 * 첽ݣǰأԺ
	 * @param key
	 * @param value
	 */
	public void asynPut(String key,Object value);
	
	
	/**
	 * 첽ۼ֤ۼɹ
	 * @param key
	 * @param decr
	 */
	public void asynAddOrDecr(String key,long decr);
	
	/**
	 * 첽ۼӼ֤ۼӳɹ
	 * @param key
	 * @param incr
	 */
	public void asynAddOrIncr(String key,long incr);
	
	/**
	 * 첽ۼ֤ۼɹ
	 * @param key
	 * @param decr
	 */
	public void asynDecr(String key,long decr);
	
	/**
	 * 첽ۼӼ֤ۼӳɹ
	 * @param key
	 * @param incr
	 */
	public void asynIncr(String key,long incr);
	
	/**
	 * 첽洢,֤ɹ
	 * @param key
	 * @param count
	 */
	public void asynStoreCounter(String key,long count); 
	
	
}
