/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.common.RpcConstants;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import com.alipay.sofa.rpc.transport.http.HttpTransportUtils;
import com.alipay.sofa.rpc.transport.netty.NettyByteBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class Http1ServerChannelHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http1ServerChannelHandler.class);
    private final HttpServerHandler serverHandler;

    public Http1ServerChannelHandler(HttpServerHandler serverHandler) {
        this.serverHandler = (HttpServerHandler)ObjectUtil.checkNotNull((Object)serverHandler, (String)"serverHandler");
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        String uri = req.uri();
        if ("/favicon.ico".equals(uri)) {
            this.sendHttp1Response(ctx, HttpResponseStatus.OK, "", keepAlive);
            return;
        }
        HttpMethod reqMethod = req.method();
        if (reqMethod == HttpMethod.HEAD) {
            String[] iam = HttpTransportUtils.getInterfaceIdAndMethod(uri);
            boolean exists = this.serverHandler.checkService(iam[0], iam[1]);
            this.sendHttp1Response(ctx, exists ? HttpResponseStatus.OK : HttpResponseStatus.NOT_FOUND, "", keepAlive);
            return;
        }
        if (reqMethod != HttpMethod.POST && reqMethod != HttpMethod.GET) {
            this.sendHttp1Response(ctx, HttpResponseStatus.BAD_REQUEST, "Only support GET/POST/HEAD", keepAlive);
            return;
        }
        SofaRequest sofaRequest = new SofaRequest();
        try {
            String[] iam = HttpTransportUtils.getInterfaceIdAndMethod(uri);
            String serviceName = iam[0];
            String methodName = iam[1];
            sofaRequest.setTargetServiceUniqueName(serviceName);
            sofaRequest.setMethodName(methodName);
            this.parseHeader(req, sofaRequest);
            if (reqMethod == HttpMethod.GET) {
                Method method = ReflectCache.getMethodCache(serviceName, methodName);
                if (method == null) {
                    this.sendHttp1Response(ctx, HttpResponseStatus.NOT_FOUND, "Not found method:" + serviceName + "." + methodName, keepAlive);
                    return;
                }
                String params = null;
                Class[] classArray = method.getParameterTypes();
                int length = classArray.length;
                Object[] paramList = new Object[length];
                int i = uri.indexOf(63);
                if (i >= 0) {
                    params = uri.substring(i + 1);
                    paramList = this.parseParamArg(classArray, params);
                } else if (length != 0) {
                    throw new SofaRpcException(130, "The number of parameter is wrong.");
                }
                sofaRequest.setMethodArgSigs(ReflectCache.getMethodSigsCache(serviceName, methodName));
                sofaRequest.setMethodArgs(paramList);
            } else {
                sofaRequest.setData(new NettyByteBuffer(req.content()));
            }
        }
        catch (Exception e) {
            String message = "Failed to parse http2 request for uri " + uri + " form " + NetUtils.channelToString(ctx.channel().remoteAddress(), ctx.channel().localAddress()) + ", cause by: " + e.getMessage();
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(message, e);
            }
            this.sendHttp1Response(ctx, HttpResponseStatus.BAD_REQUEST, message, keepAlive);
            return;
        }
        try {
            this.serverHandler.handleHttp1Request(sofaRequest, ctx, keepAlive);
        }
        catch (SofaRpcException e) {
            int type = e.getErrorType();
            if (type == 100) {
                this.sendHttp1Response(ctx, HttpResponseStatus.SERVICE_UNAVAILABLE, e.getMessage(), keepAlive);
            } else if (type == 110) {
                this.sendHttp1Response(ctx, HttpResponseStatus.NOT_FOUND, e.getMessage(), keepAlive);
            } else {
                this.sendHttp1Response(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage(), keepAlive);
            }
        }
        catch (Exception e) {
            this.sendHttp1Response(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage(), keepAlive);
        }
    }

    public Object[] parseParamArg(Class[] classTypes, String params) {
        String[] paramList = params.split("&");
        if (classTypes.length != paramList.length) {
            throw new SofaRpcException(130, "The number of parameter is wrong.");
        }
        Object[] resultList = new Object[paramList.length];
        for (int i = 0; i < classTypes.length; ++i) {
            Class cl = classTypes[i];
            String value = paramList[i].substring(paramList[i].indexOf(61) + 1).trim();
            if (String.class.equals((Object)cl)) {
                try {
                    resultList[i] = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    resultList[i] = value;
                }
                continue;
            }
            if (Boolean.TYPE.equals(cl) || Boolean.class.equals((Object)cl)) {
                resultList[i] = Boolean.parseBoolean(value);
                continue;
            }
            if (Byte.TYPE.equals(cl) || Byte.class.equals((Object)cl)) {
                resultList[i] = Byte.decode(value);
                continue;
            }
            if (Short.TYPE.equals(cl) || Short.class.equals((Object)cl)) {
                resultList[i] = Short.decode(value);
                continue;
            }
            if (Character.TYPE.equals(cl) || Character.class.equals((Object)cl)) {
                resultList[i] = Character.valueOf(value.charAt(0));
                continue;
            }
            if (Integer.TYPE.equals(cl) || Integer.class.equals((Object)cl)) {
                resultList[i] = Integer.decode(value);
                continue;
            }
            if (Long.TYPE.equals(cl) || Long.class.equals((Object)cl)) {
                resultList[i] = Long.decode(value);
                continue;
            }
            if (Float.TYPE.equals(cl) || Float.class.equals((Object)cl)) {
                resultList[i] = Float.valueOf(value);
                continue;
            }
            if (Double.TYPE.equals(cl) || Double.class.equals((Object)cl)) {
                resultList[i] = Double.valueOf(value);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return resultList;
    }

    private void parseHeader(FullHttpRequest httpRequest, SofaRequest sofaRequest) {
        byte serializeType;
        HttpHeaders headers = httpRequest.headers();
        if (httpRequest.method() == HttpMethod.GET) {
            serializeType = 0;
        } else {
            String codeName = headers.get("sofa_head_serialize_type");
            if (codeName != null) {
                serializeType = HttpTransportUtils.getSerializeTypeByName(codeName);
            } else {
                String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                serializeType = HttpTransportUtils.getSerializeTypeByContentType(contentType);
            }
        }
        sofaRequest.setSerializeType(serializeType);
        sofaRequest.setTargetAppName(headers.get("sofa_head_target_app"));
    }

    protected int sendHttp1Response(ChannelHandlerContext ctx, HttpResponseStatus status, String resultStr, boolean isKeepAlive) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)resultStr, (Charset)RpcConstants.DEFAULT_CHARSET);
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("text/html; charset=" + RpcConstants.DEFAULT_CHARSET.displayName()));
        HttpUtil.setContentLength((HttpMessage)res, (long)content.readableBytes());
        try {
            ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
            if (isKeepAlive) {
                HttpUtil.setKeepAlive((HttpMessage)res, (boolean)true);
            } else {
                HttpUtil.setKeepAlive((HttpMessage)res, (boolean)false);
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Failed to send HTTP response to remote, cause by:", e2);
        }
        return content.readableBytes();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error("", cause);
        ctx.close();
    }
}

