/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter.sofatracer;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.module.SofaTracerModule;

@Extension(value="consumerTracer", order=-10000)
@AutoActive(consumerSide=true)
public class ConsumerTracerFilter
extends Filter {
    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        return SofaTracerModule.isEnable();
    }

    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.getCurrentSpan();
        clientSpan.setTag("invoke.type", request.getInvokeType());
        RpcInternalContext context = RpcInternalContext.getContext();
        clientSpan.setTag("router.record", (String)context.getAttachment("_router_record"));
        ProviderInfo providerInfo = context.getProviderInfo();
        if (providerInfo != null) {
            clientSpan.setTag("remote.app", providerInfo.getStaticAttr("appName"));
            clientSpan.setTag("remote.ip", providerInfo.getHost() + ":" + providerInfo.getPort());
        }
        return invoker.invoke(request);
    }
}

