/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class CalculateUtils {
    public static double divide(long numerator, long denominator, int scale) {
        BigDecimal numeratorBd = new BigDecimal(numerator);
        BigDecimal denominatorBd = new BigDecimal(denominator);
        return numeratorBd.divide(denominatorBd, scale, 4).doubleValue();
    }

    public static double divide(long numerator, long denominator) {
        return CalculateUtils.divide(numerator, denominator, 2);
    }

    public static double divide(double numerator, double denominator, int scale) {
        BigDecimal numeratorBd = new BigDecimal(Double.toString(numerator));
        BigDecimal denominatorBd = new BigDecimal(Double.toString(denominator));
        return numeratorBd.divide(denominatorBd, scale, 4).doubleValue();
    }

    public static double divide(double numerator, double denominator) {
        return CalculateUtils.divide(numerator, denominator, 2);
    }

    public static double subtract(double minuend, double reduction, int scale) {
        BigDecimal minuendBd = new BigDecimal(Double.toString(minuend));
        BigDecimal reductionBd = new BigDecimal(Double.toString(reduction));
        MathContext mathContext = new MathContext(scale, RoundingMode.HALF_UP);
        return minuendBd.subtract(reductionBd, mathContext).doubleValue();
    }

    public static double subtract(double minuend, double reduction) {
        BigDecimal minuendBd = new BigDecimal(Double.toString(minuend));
        BigDecimal reductionBd = new BigDecimal(Double.toString(reduction));
        return minuendBd.subtract(reductionBd).doubleValue();
    }

    public static int multiply(int num1, double num2) {
        double num1D = num1;
        return CalculateUtils.multiply(num1D, num2);
    }

    public static int multiply(long num1, double num2) {
        double num1D = Long.valueOf(num1).doubleValue();
        return CalculateUtils.multiply(num1D, num2);
    }

    public static int multiply(double num1, double num2) {
        BigDecimal num1Bd = new BigDecimal(Double.toString(num1));
        BigDecimal num2Bd = new BigDecimal(Double.toString(num2));
        MathContext mathContext = new MathContext(num1Bd.precision(), RoundingMode.HALF_UP);
        return num1Bd.multiply(num2Bd, mathContext).intValue();
    }
}

