/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.struct;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListDifference<T> {
    private List<T> onlyOnLeft;
    private List<T> onlyOnRight;
    private List<T> onBoth;

    public ListDifference(List<? extends T> left, List<? extends T> right) {
        if (CommonUtils.isEmpty(left) || CommonUtils.isEmpty(right)) {
            this.onlyOnLeft = Collections.unmodifiableList(left == null ? new ArrayList() : left);
            this.onlyOnRight = Collections.unmodifiableList(right == null ? new ArrayList() : right);
            this.onBoth = Collections.unmodifiableList(new ArrayList());
            return;
        }
        boolean switched = false;
        if (left.size() < right.size()) {
            ArrayList tmp = left;
            left = right;
            right = tmp;
            switched = true;
        }
        ArrayList onlyOnLeft = new ArrayList();
        ArrayList onlyOnRight = new ArrayList(right);
        ArrayList onBoth = new ArrayList();
        for (Object leftValue : left) {
            if (right.contains(leftValue)) {
                onlyOnRight.remove(leftValue);
                onBoth.add(leftValue);
                continue;
            }
            onlyOnLeft.add(leftValue);
        }
        this.onlyOnLeft = Collections.unmodifiableList(switched ? onlyOnRight : onlyOnLeft);
        this.onlyOnRight = Collections.unmodifiableList(switched ? onlyOnLeft : onlyOnRight);
        this.onBoth = Collections.unmodifiableList(onBoth);
    }

    public boolean areEqual() {
        return this.onlyOnLeft.isEmpty() && this.onlyOnRight.isEmpty();
    }

    public List<T> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public List<T> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public List<T> getOnBoth() {
        return this.onBoth;
    }
}

