/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.sofahessian.serialize;

import com.alipay.sofa.rpc.codec.sofahessian.serialize.AbstractCustomHessianSerializer;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayInputStream;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayOutputStream;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteStreamWrapperByteBuf;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class SofaRequestHessianSerializer
extends AbstractCustomHessianSerializer<SofaRequest> {
    public SofaRequestHessianSerializer(SerializerFactory serializerFactory, SerializerFactory genericSerializerFactory) {
        super(serializerFactory, genericSerializerFactory);
    }

    @Override
    public void decodeObjectByTemplate(AbstractByteBuf data, Map<String, String> context, SofaRequest template) throws SofaRpcException {
        try {
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            input.setSerializerFactory(this.serializerFactory);
            Object object = input.readObject();
            SofaRequest tmp = (SofaRequest)object;
            String targetServiceName = tmp.getTargetServiceUniqueName();
            if (targetServiceName == null) {
                throw this.buildDeserializeError("Target service name of request is null!");
            }
            template.setMethodName(tmp.getMethodName());
            template.setMethodArgSigs(tmp.getMethodArgSigs());
            template.setTargetServiceUniqueName(tmp.getTargetServiceUniqueName());
            template.setTargetAppName(tmp.getTargetAppName());
            template.addRequestProps(tmp.getRequestProps());
            String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetServiceName);
            template.setInterfaceName(interfaceName);
            String[] sig = template.getMethodArgSigs();
            Class[] classSig = ClassTypeUtils.getClasses(sig);
            Object[] args = new Object[sig.length];
            for (int i = 0; i < template.getMethodArgSigs().length; ++i) {
                args[i] = input.readObject(classSig[i]);
            }
            template.setMethodArgs(args);
            input.close();
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    @Override
    public SofaRequest decodeObject(AbstractByteBuf data, Map<String, String> context) throws SofaRpcException {
        try {
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            input.setSerializerFactory(this.serializerFactory);
            Object object = input.readObject();
            SofaRequest sofaRequest = (SofaRequest)object;
            String targetServiceName = sofaRequest.getTargetServiceUniqueName();
            if (targetServiceName == null) {
                throw this.buildDeserializeError("Target service name of request is null!");
            }
            String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetServiceName);
            sofaRequest.setInterfaceName(interfaceName);
            String[] sig = sofaRequest.getMethodArgSigs();
            Class[] classSig = ClassTypeUtils.getClasses(sig);
            Object[] args = new Object[sig.length];
            for (int i = 0; i < sofaRequest.getMethodArgSigs().length; ++i) {
                args[i] = input.readObject(classSig[i]);
            }
            sofaRequest.setMethodArgs(args);
            input.close();
            return sofaRequest;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    @Override
    public AbstractByteBuf encodeObject(SofaRequest sofaRequest, Map<String, String> context) {
        try {
            boolean genericSerialize;
            UnsafeByteArrayOutputStream outputStream = new UnsafeByteArrayOutputStream();
            Hessian2Output output = new Hessian2Output((OutputStream)outputStream);
            boolean bl = genericSerialize = context != null && this.isGenericRequest(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                output.setSerializerFactory(this.genericSerializerFactory);
            } else {
                output.setSerializerFactory(this.serializerFactory);
            }
            output.writeObject((Object)sofaRequest);
            Object[] args = sofaRequest.getMethodArgs();
            if (args != null) {
                for (Object arg : args) {
                    output.writeObject(arg);
                }
            }
            output.close();
            return new ByteStreamWrapperByteBuf(outputStream);
        }
        catch (IOException e) {
            throw this.buildSerializeError(e.getMessage(), e);
        }
    }
}

