/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.sofahessian;

import com.alipay.hessian.generic.io.GenericArraySerializer;
import com.alipay.hessian.generic.io.GenericClassDeserializer;
import com.alipay.hessian.generic.io.GenericClassSerializer;
import com.alipay.hessian.generic.io.GenericCollectionSerializer;
import com.alipay.hessian.generic.io.GenericDeserializer;
import com.alipay.hessian.generic.io.GenericMapSerializer;
import com.alipay.hessian.generic.io.GenericObjectSerializer;
import com.alipay.hessian.generic.model.GenericArray;
import com.alipay.hessian.generic.model.GenericClass;
import com.alipay.hessian.generic.model.GenericCollection;
import com.alipay.hessian.generic.model.GenericMap;
import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.hessian.generic.util.ClassFilter;
import com.alipay.sofa.rpc.codec.sofahessian.SingleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GenericSingleClassLoaderSofaSerializerFactory
extends SingleClassLoaderSofaSerializerFactory {
    private static final char ARRAY_PREFIX = '[';
    private static final ConcurrentMap<String, Deserializer> DESERIALIZER_MAP = new ConcurrentHashMap<String, Deserializer>();

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (GenericObject.class == cl) {
            return GenericObjectSerializer.getInstance();
        }
        if (GenericArray.class == cl) {
            return GenericArraySerializer.getInstance();
        }
        if (GenericCollection.class == cl) {
            return GenericCollectionSerializer.getInstance();
        }
        if (GenericMap.class == cl) {
            return GenericMapSerializer.getInstance();
        }
        if (GenericClass.class == cl) {
            return GenericClassSerializer.getInstance();
        }
        return super.getSerializer(cl);
    }

    @Override
    public Deserializer getDeserializer(String type) throws HessianProtocolException {
        if (StringUtils.isEmpty(type) || ClassFilter.filterExcludeClass((String)type)) {
            return super.getDeserializer(type);
        }
        if (type.charAt(0) == '[' && ClassFilter.arrayFilter((String)type)) {
            return super.getDeserializer(type);
        }
        Object deserializer = (Deserializer)DESERIALIZER_MAP.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = ClassFilter.CLASS_NAME.equals(type) ? GenericClassDeserializer.getInstance() : new GenericDeserializer(type);
        DESERIALIZER_MAP.putIfAbsent(type, (Deserializer)deserializer);
        return deserializer;
    }
}

