/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.msgpack;

import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MsgPackHelper {
    private ConcurrentMap<String, Class> requestClassCache = new ConcurrentHashMap<String, Class>();
    private ConcurrentMap<String, Class> responseClassCache = new ConcurrentHashMap<String, Class>();

    public Class getReqClass(String service, String methodName) {
        String key = this.buildMethodKey(service, methodName);
        return this.getCachedClass(service, methodName, key, this.requestClassCache);
    }

    public Class getResClass(String service, String methodName) {
        String key = service + "#" + methodName;
        return this.getCachedClass(service, methodName, key, this.responseClassCache);
    }

    private Class getCachedClass(String service, String methodName, String key, ConcurrentMap<String, Class> classCache) {
        Class reqClass = (Class)classCache.get(key);
        if (reqClass == null) {
            String interfaceClass = ConfigUniqueNameGenerator.getInterfaceName(service);
            Class clazz = ClassUtils.forName(interfaceClass, true);
            this.loadClassToCache(key, clazz, methodName);
        }
        return (Class)classCache.get(key);
    }

    private String buildMethodKey(String serviceName, String methodName) {
        return serviceName + "#" + methodName;
    }

    private void loadClassToCache(String key, Class clazz, String methodName) {
        Method[] methods;
        Method pbMethod = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            pbMethod = method;
            break;
        }
        if (pbMethod == null) {
            throw new SofaRpcRuntimeException("Cannot found method: " + clazz.getName() + "." + methodName);
        }
        Class<?>[] parameterTypes = pbMethod.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length != 1) {
            throw new SofaRpcRuntimeException("class based msgpack: " + clazz.getName() + ", only support one parameter!");
        }
        Class<?> reqClass = parameterTypes[0];
        this.requestClassCache.put(key, reqClass);
        Class<?> resClass = pbMethod.getReturnType();
        if (resClass == Void.TYPE) {
            throw new SofaRpcRuntimeException("class based msgpack: " + clazz.getName() + ", do not support void return type!");
        }
        this.responseClassCache.put(key, resClass);
    }

    public boolean isJavaClass(Object object) {
        Class<?> clazz = object.getClass();
        return clazz != null && this.isJavaClass(clazz);
    }

    public boolean isJavaClass(Class clazz) {
        return clazz.getClassLoader() == null;
    }
}

