/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.ClientStartInvokeEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.invoke.Invoker;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ClientProxyInvoker
implements Invoker {
    protected final ConsumerConfig consumerConfig;
    protected Cluster cluster;

    public ClientProxyInvoker(ConsumerBootstrap bootstrap) {
        this.consumerConfig = bootstrap.getConsumerConfig();
        this.cluster = bootstrap.getCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SofaResponse invoke(SofaRequest request) throws SofaRpcException {
        SofaResponse response = null;
        SofaRpcException throwable = null;
        try {
            RpcInternalContext.pushContext();
            RpcInternalContext context = RpcInternalContext.getContext();
            context.setProviderSide(false);
            this.decorateRequest(request);
            try {
                if (EventBus.isEnable(ClientStartInvokeEvent.class)) {
                    EventBus.post(new ClientStartInvokeEvent(request));
                }
                response = this.cluster.invoke(request);
            }
            catch (SofaRpcException e) {
                throwable = e;
                throw e;
            }
            finally {
                if (!request.isAsync() && EventBus.isEnable(ClientEndInvokeEvent.class)) {
                    EventBus.post(new ClientEndInvokeEvent(request, response, throwable));
                }
            }
            this.decorateResponse(response);
            SofaResponse sofaResponse = response;
            return sofaResponse;
        }
        finally {
            RpcInternalContext.removeContext();
            RpcInternalContext.popContext();
        }
    }

    protected void decorateRequest(SofaRequest request) {
    }

    protected void decorateResponse(SofaResponse response) {
    }

    public ConsumerConfig<?> getConsumerConfig() {
        return this.consumerConfig;
    }

    public Cluster setCluster(Cluster newCluster) {
        Cluster old = this.cluster;
        this.cluster = newCluster;
        return old;
    }

    public Cluster getCluster() {
        return this.cluster;
    }
}

