/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.grpc;

import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.alipay.sofa.rpc.server.ProviderProxyInvoker;
import com.alipay.sofa.rpc.server.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="grpc")
public class GrpcProviderBootstrap<T>
extends ProviderBootstrap<T> {
    protected volatile transient boolean exported;
    private Server server;
    private String host;
    private int port;
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcProviderBootstrap.class);
    protected transient Invoker providerProxyInvoker;
    protected static final ConcurrentMap<String, AtomicInteger> EXPORTED_KEYS = new ConcurrentHashMap<String, AtomicInteger>();
    private final ThreadFactory factory = new NamedThreadFactory("DELAY-EXPORT", true);

    protected GrpcProviderBootstrap(ProviderConfig<T> providerConfig) {
        super(providerConfig);
    }

    @Override
    public void export() {
        if (this.exported) {
            return;
        }
        String interfaceType = this.providerConfig.getInterfaceId();
        Object ref = this.providerConfig.getRef();
        if (ref instanceof String) {
            try {
                ref = this.getInterfaceClass(interfaceType).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String appName = this.providerConfig.getAppName();
        ConcurrentHashMap<String, Boolean> hasExportedInCurrent = new ConcurrentHashMap<String, Boolean>();
        List<ServerConfig> serverConfigs = this.providerConfig.getServer();
        for (ServerConfig serverConfig : serverConfigs) {
            AtomicInteger cnt;
            String protocol = serverConfig.getProtocol();
            String key = this.providerConfig.buildKey() + ":" + protocol;
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "Export provider config : {} with bean id {}", key, this.providerConfig.getId());
            }
            if ((cnt = (AtomicInteger)EXPORTED_KEYS.get(key)) == null) {
                cnt = CommonUtils.putToConcurrentMap(EXPORTED_KEYS, key, new AtomicInteger(0));
            }
            int c = cnt.incrementAndGet();
            hasExportedInCurrent.put(serverConfig.getProtocol(), true);
            int maxProxyCount = this.providerConfig.getRepeatedExportLimit();
            if (maxProxyCount <= 0) continue;
            if (c > maxProxyCount) {
                this.decrementCounter(hasExportedInCurrent);
                throw new SofaRpcRuntimeException("Duplicate provider config with key " + key + " has been exported more than " + maxProxyCount + " times! Maybe it's wrong config, please check it. Ignore this if you did that on purpose!");
            }
            if (c <= 1 || !LOGGER.isInfoEnabled(appName)) continue;
            LOGGER.infoWithApp(appName, "Duplicate provider config with key {} has been exported! Maybe it's wrong config, please check it. Ignore this if you did that on purpose!", key);
        }
        try {
            Object registryConfigs;
            this.providerProxyInvoker = new ProviderProxyInvoker(this.providerConfig);
            if (this.providerConfig.isRegister() && CommonUtils.isNotEmpty((Collection)(registryConfigs = this.providerConfig.getRegistry()))) {
                Iterator iterator = registryConfigs.iterator();
                while (iterator.hasNext()) {
                    RegistryConfig registryConfig = (RegistryConfig)iterator.next();
                    RegistryFactory.getRegistry(registryConfig);
                }
            }
            for (ServerConfig serverConfig : serverConfigs) {
                try {
                    Server server = serverConfig.buildIfAbsent();
                    server.registerProcessor(this.providerConfig, this.providerProxyInvoker);
                    server.start();
                }
                catch (SofaRpcRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, "Catch exception when register processor to server: " + serverConfig.getId(), e);
                }
            }
            this.providerConfig.setConfigListener(new ProviderAttributeListener());
            this.register();
        }
        catch (Exception e) {
            this.decrementCounter(hasExportedInCurrent);
            if (e instanceof SofaRpcRuntimeException) {
                throw (SofaRpcRuntimeException)e;
            }
            throw new SofaRpcRuntimeException("Build provider proxy error!", e);
        }
        RpcRuntimeContext.cacheProviderConfig(this);
        this.exported = true;
        this.port = this.providerConfig.getServer().get(0).getPort();
        LOGGER.info("GRPC server starts successfully, port: {}", this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getInterfaceClass(String interfaceType) {
        try {
            Class<?> interfaceClass;
            Class<?> clazz = interfaceClass = this.getClass().getClassLoader().loadClass(interfaceType);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NullPointerException e) {
            Object var3_6 = null;
            return var3_6;
        }
        finally {
            return null;
        }
    }

    @Override
    public synchronized void unExport() {
        if (!this.exported) {
            return;
        }
        this.exported = false;
    }

    public List<String> buildUrls() {
        List<ServerConfig> servers;
        if (this.exported && (servers = this.providerConfig.getServer()) != null && !servers.isEmpty()) {
            ArrayList<String> urls = new ArrayList<String>();
            for (ServerConfig server : servers) {
                StringBuilder sb = new StringBuilder(200);
                sb.append(server.getProtocol()).append("://").append(server.getHost()).append(":").append(server.getPort()).append(server.getContextPath()).append(this.providerConfig.getInterfaceId()).append("?uniqueId=").append(this.providerConfig.getUniqueId()).append(this.getKeyPairs("version", "1.0")).append(this.getKeyPairs("delay", this.providerConfig.getDelay())).append(this.getKeyPairs("weight", this.providerConfig.getWeight())).append(this.getKeyPairs("register", this.providerConfig.isRegister())).append(this.getKeyPairs("maxThreads", server.getMaxThreads())).append(this.getKeyPairs("ioThreads", server.getIoThreads())).append(this.getKeyPairs("threadPoolType", server.getThreadPoolType())).append(this.getKeyPairs("accepts", server.getAccepts())).append(this.getKeyPairs("dynamic", this.providerConfig.isDynamic())).append(this.getKeyPairs("rpcVer", 50604));
                urls.add(sb.toString());
            }
            return urls;
        }
        return null;
    }

    private String getKeyPairs(String key, Object value) {
        if (value != null) {
            return "&" + key + "=" + value.toString();
        }
        return "";
    }

    private void decrementCounter(Map<String, Boolean> hasExportedInCurrent) {
        for (Map.Entry<String, Boolean> entry : hasExportedInCurrent.entrySet()) {
            String protocol = entry.getKey();
            String key = this.providerConfig.buildKey() + ":" + protocol;
            AtomicInteger cnt = (AtomicInteger)EXPORTED_KEYS.get(key);
            if (cnt == null || cnt.get() <= 0) continue;
            cnt.decrementAndGet();
        }
    }

    protected void register() {
        List<RegistryConfig> registryConfigs;
        if (this.providerConfig.isRegister() && (registryConfigs = this.providerConfig.getRegistry()) != null) {
            for (RegistryConfig registryConfig : registryConfigs) {
                Registry registry = RegistryFactory.getRegistry(registryConfig);
                registry.init();
                registry.start();
                try {
                    registry.register(this.providerConfig);
                }
                catch (SofaRpcRuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    String appName = this.providerConfig.getAppName();
                    if (!LOGGER.isWarnEnabled(appName)) continue;
                    LOGGER.warnWithApp(appName, "Catch exception when register to registry: " + registryConfig.getId(), e);
                }
            }
        }
    }

    private class ProviderAttributeListener
    implements ConfigListener {
        private ProviderAttributeListener() {
        }

        @Override
        public void configChanged(Map newValue) {
        }

        @Override
        public synchronized void attrUpdated(Map newValueMap) {
            String appName = GrpcProviderBootstrap.this.providerConfig.getAppName();
            Map newValues = newValueMap;
            HashMap oldValues = new HashMap();
            boolean reexport = false;
            try {
                for (Map.Entry entry : newValues.entrySet()) {
                    boolean changed;
                    String newValue = (String)entry.getValue();
                    String oldValue = GrpcProviderBootstrap.this.providerConfig.queryAttribute((String)entry.getKey());
                    boolean bl = oldValue == null ? newValue != null : (changed = !oldValue.equals(newValue));
                    if (changed) {
                        oldValues.put(entry.getKey(), oldValue);
                    }
                    reexport = reexport || changed;
                }
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Catch exception when provider attribute compare", e);
                return;
            }
            if (reexport) {
                try {
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, "Reexport service {}", GrpcProviderBootstrap.this.providerConfig.buildKey());
                    }
                    GrpcProviderBootstrap.this.unExport();
                    for (Map.Entry entry : newValues.entrySet()) {
                        GrpcProviderBootstrap.this.providerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    GrpcProviderBootstrap.this.export();
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, "Catch exception when provider attribute changed", e);
                    for (Map.Entry entry : oldValues.entrySet()) {
                        GrpcProviderBootstrap.this.providerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    GrpcProviderBootstrap.this.export();
                }
            }
        }
    }
}

