/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.api.future;

import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaTimeOutException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.message.ResponseFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SofaResponseFuture {
    public static boolean isDone() throws SofaRpcException {
        return SofaResponseFuture.getFuture().isDone();
    }

    public static Object getResponse(long timeout, boolean clear) throws SofaRpcException, InterruptedException {
        RpcInvokeContext context = RpcInvokeContext.getContext();
        ResponseFuture future = context.getFuture();
        if (null == future) {
            throw new SofaRpcException(299, LogCodes.getLog("02401", Thread.currentThread()));
        }
        try {
            if (clear) {
                context.setFuture(null);
            }
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            if (!future.isDone()) {
                throw new SofaTimeOutException("Future is not done when timeout.", (Throwable)ex);
            }
            throw new SofaTimeOutException(ex.getMessage(), (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SofaRpcException) {
                throw (SofaRpcException)cause;
            }
            throw new SofaRpcException(199, cause.getMessage(), cause);
        }
    }

    public static Future getFuture() throws SofaRpcException {
        return SofaResponseFuture.getFuture(false);
    }

    public static Future getFuture(boolean clear) throws SofaRpcException {
        RpcInvokeContext context = RpcInvokeContext.getContext();
        ResponseFuture future = context.getFuture();
        if (future == null) {
            throw new SofaRpcException(299, LogCodes.getLog("02401", Thread.currentThread()));
        }
        if (clear) {
            context.setFuture(null);
        }
        return future;
    }
}

