/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import com.alipay.sofa.jraft.rpc.RaftRpcFactory;
import com.alipay.sofa.jraft.rpc.RpcClient;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.GrpcClient;
import com.alipay.sofa.jraft.rpc.impl.GrpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.GrpcServer;
import com.alipay.sofa.jraft.rpc.impl.MarshallerHelper;
import com.alipay.sofa.jraft.rpc.impl.MarshallerRegistry;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SPI;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.google.protobuf.Message;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SPI(priority=1)
public class GrpcRaftRpcFactory
implements RaftRpcFactory {
    static final String FIXED_METHOD_NAME = "_call";
    static final int RPC_SERVER_PROCESSOR_POOL_SIZE = SystemPropertyUtil.getInt((String)"grpc.default_rpc_server_processor_pool_size", (int)100);
    static final RpcResponseFactory RESPONSE_FACTORY = new GrpcResponseFactory();
    final Map<String, Message> parserClasses = new ConcurrentHashMap<String, Message>();
    final MarshallerRegistry defaultMarshallerRegistry = new MarshallerRegistry(){

        @Override
        public Message findResponseInstanceByRequest(String reqCls) {
            return MarshallerHelper.findRespInstance(reqCls);
        }

        @Override
        public void registerResponseInstance(String reqCls, Message respIns) {
            MarshallerHelper.registerRespInstance(reqCls, respIns);
        }
    };

    public void registerProtobufSerializer(String className, Object ... args) {
        this.parserClasses.put(className, (Message)args[0]);
    }

    public RpcClient createRpcClient(RaftRpcFactory.ConfigHelper<RpcClient> helper) {
        GrpcClient rpcClient = new GrpcClient(this.parserClasses, this.getMarshallerRegistry());
        if (helper != null) {
            helper.config((Object)rpcClient);
        }
        return rpcClient;
    }

    public RpcServer createRpcServer(Endpoint endpoint, RaftRpcFactory.ConfigHelper<RpcServer> helper) {
        int port = ((Endpoint)Requires.requireNonNull((Object)endpoint, (String)"endpoint")).getPort();
        Requires.requireTrue((port > 0 && port < 65535 ? 1 : 0) != 0, (Object)("port out of range:" + port));
        MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
        Server server = ServerBuilder.forPort((int)port).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry).directExecutor().build();
        GrpcServer rpcServer = new GrpcServer(server, handlerRegistry, this.parserClasses, this.getMarshallerRegistry());
        if (helper != null) {
            helper.config((Object)rpcServer);
        }
        return rpcServer;
    }

    public RpcResponseFactory getRpcResponseFactory() {
        return RESPONSE_FACTORY;
    }

    public boolean isReplicatorPipelineEnabled() {
        return true;
    }

    public MarshallerRegistry getMarshallerRegistry() {
        return this.defaultMarshallerRegistry;
    }
}

