/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.processor;

import com.alipay.sofa.registry.jraft.command.CommandCodec;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractSnapshotProcess
implements SnapshotProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSnapshotProcess.class);

    public boolean save(String path, Object values) {
        try {
            FileUtils.writeByteArrayToFile((File)new File(path), (byte[])CommandCodec.encodeCommand(values), (boolean)false);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Fail to save snapshot", (Throwable)e);
            return false;
        }
    }

    public <T> T load(String path, Class<T> clazz) throws IOException {
        byte[] bs = FileUtils.readFileToByteArray((File)new File(path));
        if (bs != null && bs.length > 0) {
            return CommandCodec.decodeCommand(bs, clazz);
        }
        throw new IOException("Fail to load snapshot from " + path + ", content: " + Arrays.toString(bs));
    }
}

