/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.store.api;

import com.alipay.sofa.registry.store.api.OperationStatus;
import java.io.Serializable;

public class DBResponse
implements Serializable {
    private final Object entity;
    private final OperationStatus operationStatus;

    public DBResponse(Object entity, OperationStatus operationStatus) {
        this.entity = entity;
        this.operationStatus = operationStatus;
    }

    public static DBResponseBuilder ok() {
        return DBResponse.setStatus(OperationStatus.SUCCESS);
    }

    public static DBResponseBuilder ok(Object entity) {
        DBResponseBuilder b = DBResponse.ok();
        b.entity(entity);
        return b;
    }

    public static DBResponseBuilder notfound() {
        return DBResponse.setStatus(OperationStatus.NOTFOUND);
    }

    protected static DBResponseBuilder setStatus(OperationStatus status) {
        DBResponseBuilder b = DBResponseBuilder.getInstance();
        b.status(status);
        return b;
    }

    public Object getEntity() {
        return this.entity;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public static class DBResponseBuilder {
        private static volatile DBResponseBuilder instance;
        private Object entity;
        private OperationStatus operationStatus;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DBResponseBuilder getInstance() {
            if (instance != null) return instance;
            Class<DBResponseBuilder> clazz = DBResponseBuilder.class;
            synchronized (DBResponseBuilder.class) {
                if (instance != null) return instance;
                instance = new DBResponseBuilder();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        public DBResponse build() {
            DBResponse r = new DBResponse(this.entity, this.operationStatus);
            this.reset();
            return r;
        }

        private void reset() {
            this.operationStatus = null;
            this.entity = null;
        }

        public DBResponseBuilder status(OperationStatus status) {
            if (status == null) {
                throw new IllegalArgumentException();
            }
            this.operationStatus = status;
            return this;
        }

        public DBResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }
    }
}

