/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.wrapper;

import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.wrapper.WrapperInterceptor;
import com.alipay.sofa.registry.server.session.wrapper.WrapperInvocation;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientCheckWrapperInterceptor
implements WrapperInterceptor<StoreData, Boolean> {
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Exchange boltExchange;

    @Override
    public Boolean invokeCodeWrapper(WrapperInvocation<StoreData, Boolean> invocation) throws Exception {
        BaseInfo baseInfo = (BaseInfo)invocation.getParameterSupplier().get();
        Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
        Channel channel = sessionServer.getChannel(baseInfo.getSourceAddress());
        if (channel == null) {
            throw new RuntimeException(String.format("Register address %s  has not connected session server!", baseInfo.getSourceAddress()));
        }
        return invocation.proceed();
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

