/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.wrapper;

import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.filter.ProcessFilter;
import com.alipay.sofa.registry.server.session.registry.SessionRegistry;
import com.alipay.sofa.registry.server.session.wrapper.WrapperInterceptor;
import com.alipay.sofa.registry.server.session.wrapper.WrapperInvocation;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import org.springframework.beans.factory.annotation.Autowired;

public class BlacklistWrapperInterceptor
implements WrapperInterceptor<StoreData, Boolean> {
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(SessionRegistry.class, (String)"[Task]");
    @Autowired
    private TaskListenerManager taskListenerManager;
    @Autowired
    private ProcessFilter<BaseInfo> processFilter;

    @Override
    public Boolean invokeCodeWrapper(WrapperInvocation<StoreData, Boolean> invocation) throws Exception {
        BaseInfo storeData = (BaseInfo)invocation.getParameterSupplier().get();
        if (this.processFilter.match(storeData)) {
            if (StoreData.DataType.PUBLISHER == storeData.getDataType()) {
                return true;
            }
            if (StoreData.DataType.SUBSCRIBER == storeData.getDataType()) {
                this.fireSubscriberPushEmptyTask((Subscriber)storeData);
                return true;
            }
        }
        return invocation.proceed();
    }

    @Override
    public int getOrder() {
        return 200;
    }

    private void fireSubscriberPushEmptyTask(Subscriber subscriber) {
        TaskEvent taskEvent = new TaskEvent((Object)subscriber, TaskEvent.TaskType.SUBSCRIBER_PUSH_EMPTY_TASK);
        TASK_LOGGER.info("send " + taskEvent.getTaskType() + " taskEvent:{}", (Object)taskEvent);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }
}

