/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.wrapper;

import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.server.session.limit.AccessLimitService;
import com.alipay.sofa.registry.server.session.wrapper.WrapperInterceptor;
import com.alipay.sofa.registry.server.session.wrapper.WrapperInvocation;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessLimitWrapperInterceptor
implements WrapperInterceptor<StoreData, Boolean> {
    @Autowired
    private AccessLimitService accessLimitService;

    @Override
    public Boolean invokeCodeWrapper(WrapperInvocation<StoreData, Boolean> invocation) throws Exception {
        BaseInfo baseInfo = (BaseInfo)invocation.getParameterSupplier().get();
        if (!this.accessLimitService.tryAcquire()) {
            throw new RuntimeException(String.format("Register access limit for session server!dataInfoId=%s,connectId=%s", baseInfo.getDataInfoId(), baseInfo.getSourceAddress()));
        }
        return invocation.proceed();
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

