/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.strategy.impl;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.converter.ReceivedDataConverter;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.server.session.strategy.SubscriberRegisterFetchTaskStrategy;
import com.alipay.sofa.registry.server.session.utils.DatumUtils;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultSubscriberRegisterFetchTaskStrategy
implements SubscriberRegisterFetchTaskStrategy {
    private static final Logger taskLogger = LoggerFactory.getLogger(DefaultSubscriberRegisterFetchTaskStrategy.class, (String)"[Task]");

    @Override
    public void doSubscriberRegisterFetchTask(SessionServerConfig sessionServerConfig, TaskListenerManager taskListenerManager, DataNodeService dataNodeService, CacheService sessionCacheService, Subscriber subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("Subscriber can not be null!");
        }
        List<String> subscriberRegisterIdList = Collections.singletonList(subscriber.getRegisterId());
        boolean isOldVersion = !BaseInfo.ClientVersion.StoreData.equals((Object)subscriber.getClientVersion());
        Map<String, Datum> datumMap = dataNodeService.fetchGlobal(subscriber.getDataInfoId());
        if (!isOldVersion) {
            this.fireReceivedDataPushTaskCloud(datumMap, subscriberRegisterIdList, subscriber, taskListenerManager);
        } else {
            this.fireUserDataPushTaskCloud(datumMap, subscriber, taskListenerManager);
        }
    }

    private void fireReceivedDataPushTaskCloud(Map<String, Datum> datumMap, List<String> subscriberRegisterIdList, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        ReceivedData receivedData = datumMap != null && !datumMap.isEmpty() ? ReceivedDataConverter.getReceivedDataMulti(datumMap, subscriber.getScope(), subscriberRegisterIdList, subscriber) : ReceivedDataConverter.getReceivedDataMulti(subscriber.getDataId(), subscriber.getGroup(), subscriber.getInstanceId(), "DefaultDataCenter", subscriber.getScope(), subscriberRegisterIdList, subscriber.getCell());
        this.firePush(receivedData, subscriber, taskListenerManager);
    }

    private void firePush(ReceivedData receivedData, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        HashMap<ReceivedData, URL> parameter = new HashMap<ReceivedData, URL>();
        parameter.put(receivedData, subscriber.getSourceAddress());
        TaskEvent taskEvent = new TaskEvent(parameter, TaskEvent.TaskType.RECEIVED_DATA_MULTI_PUSH_TASK);
        taskLogger.info("send {} taskURL:{},taskScope:{},taskId:{}", new Object[]{taskEvent.getTaskType(), subscriber.getSourceAddress(), receivedData.getScope(), taskEvent.getTaskId()});
        taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void fireUserDataPushTaskCloud(Map<String, Datum> datumMap, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        Datum merge = null;
        if (datumMap != null && !datumMap.isEmpty()) {
            merge = ReceivedDataConverter.getMergeDatum(datumMap);
        }
        if (subscriber.getScope() == ScopeEnum.zone) {
            this.fireUserDataElementPushTask(merge, subscriber, taskListenerManager);
        } else {
            this.fireUserDataElementMultiPushTask(merge, subscriber, taskListenerManager);
        }
    }

    private void fireUserDataElementPushTask(Datum datum, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        datum = DatumUtils.newDatumIfNull(datum, subscriber);
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
        subscribers.add(subscriber);
        TaskEvent taskEvent = new TaskEvent((Object)subscriber, TaskEvent.TaskType.USER_DATA_ELEMENT_PUSH_TASK);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)subscriber.getSourceAddress());
        int size = datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},taskId={}", new Object[]{taskEvent.getTaskType(), subscriber.getSourceAddress(), datum.getDataInfoId(), datum.getDataCenter(), size, taskEvent.getTaskId()});
        taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void fireUserDataElementMultiPushTask(Datum datum, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        datum = DatumUtils.newDatumIfNull(datum, subscriber);
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
        subscribers.add(subscriber);
        TaskEvent taskEvent = new TaskEvent((Object)subscriber, TaskEvent.TaskType.USER_DATA_ELEMENT_MULTI_PUSH_TASK);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)subscriber.getSourceAddress());
        int size = datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},taskId={}", new Object[]{taskEvent.getTaskType(), subscriber.getSourceAddress(), datum.getDataInfoId(), datum.getDataCenter(), size, taskEvent.getTaskId()});
        taskListenerManager.sendTaskEvent(taskEvent);
    }
}

