/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.strategy.impl;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheAccessException;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.cache.DatumKey;
import com.alipay.sofa.registry.server.session.cache.Key;
import com.alipay.sofa.registry.server.session.cache.Value;
import com.alipay.sofa.registry.server.session.converter.ReceivedDataConverter;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.NodeManagerFactory;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.strategy.SubscriberMultiFetchTaskStrategy;
import com.alipay.sofa.registry.server.session.utils.DatumUtils;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultSubscriberMultiFetchTaskStrategy
implements SubscriberMultiFetchTaskStrategy {
    private static final Logger taskLogger = LoggerFactory.getLogger(DefaultSubscriberMultiFetchTaskStrategy.class, (String)"[Task]");
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSubscriberMultiFetchTaskStrategy.class);
    @Autowired
    private Interests sessionInterests;

    @Override
    public void doSubscriberMultiFetchTask(SessionServerConfig sessionServerConfig, TaskListenerManager taskListenerManager, CacheService sessionCacheService, String fetchDataInfoId, Collection<Subscriber> subscribers) {
        Map<String, Datum> datumMap = this.getDatumsCache(fetchDataInfoId, sessionCacheService);
        for (ScopeEnum scopeEnum : ScopeEnum.values()) {
            Map<InetSocketAddress, Map<String, Subscriber>> map = this.getPushSubscribers(scopeEnum, subscribers);
            if (map == null || map.isEmpty()) continue;
            for (Map.Entry<InetSocketAddress, Map<String, Subscriber>> entry : map.entrySet()) {
                boolean isOldVersion;
                Map<String, Subscriber> subscriberMap = entry.getValue();
                if (subscriberMap == null || subscriberMap.isEmpty()) continue;
                Subscriber subscriber = subscriberMap.values().iterator().next();
                boolean bl = isOldVersion = !BaseInfo.ClientVersion.StoreData.equals((Object)subscriber.getClientVersion());
                if (isOldVersion) {
                    this.fireUserDataPushTaskCloud(entry.getKey(), datumMap, subscriberMap.values(), subscriber, taskListenerManager);
                    continue;
                }
                this.fireReceivedDataPushTaskCloud(datumMap, new ArrayList<String>(subscriberMap.keySet()), subscriber, taskListenerManager);
            }
        }
    }

    private Map<String, Datum> getDatumsCache(String fetchDataInfoId, CacheService sessionCacheService) {
        HashMap<String, Datum> map = new HashMap<String, Datum>();
        NodeManager nodeManager = NodeManagerFactory.getNodeManager(Node.NodeType.META);
        Collection<String> dataCenters = nodeManager.getDataCenters();
        if (dataCenters != null) {
            Collection keys = dataCenters.stream().map(dataCenter -> new Key(Key.KeyType.OBJ, DatumKey.class.getName(), new DatumKey(fetchDataInfoId, (String)dataCenter))).collect(Collectors.toList());
            Map<Key, Value> values = null;
            try {
                values = sessionCacheService.getValues(keys);
            }
            catch (CacheAccessException e) {
                for (String dataCenter2 : dataCenters) {
                    boolean result = this.sessionInterests.checkAndUpdateInterestVersionZero(dataCenter2, fetchDataInfoId);
                    LOGGER.error(String.format("error when access cache, so checkAndUpdateInterestVersionZero(return %s): %s", result, e.getMessage()), (Throwable)e);
                }
            }
            if (values != null) {
                values.forEach((key, value) -> {
                    if (value != null && value.getPayload() != null) {
                        Datum datum = (Datum)value.getPayload();
                        String dataCenter = ((DatumKey)key.getEntityType()).getDataCenter();
                        map.put(dataCenter, datum);
                    }
                });
            }
        }
        return map;
    }

    private Map<InetSocketAddress, Map<String, Subscriber>> getPushSubscribers(ScopeEnum scopeEnum, Collection<Subscriber> subscribers) {
        HashMap<InetSocketAddress, Map<String, Subscriber>> payload = new HashMap<InetSocketAddress, Map<String, Subscriber>>();
        subscribers.forEach(subscriber -> {
            if (subscriber.getScope().equals((Object)scopeEnum)) {
                InetSocketAddress address = new InetSocketAddress(subscriber.getSourceAddress().getIpAddress(), subscriber.getSourceAddress().getPort());
                Map map = payload.computeIfAbsent(address, k -> new HashMap());
                map.put(subscriber.getRegisterId(), subscriber);
                payload.put(address, map);
            }
        });
        return payload;
    }

    private void fireUserDataPushTaskCloud(InetSocketAddress address, Map<String, Datum> datumMap, Collection<Subscriber> subscribers, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        ScopeEnum scopeEnum;
        Datum merge = null;
        if (datumMap != null && !datumMap.isEmpty()) {
            merge = ReceivedDataConverter.getMergeDatum(datumMap);
        }
        if ((scopeEnum = subscriber.getScope()) == ScopeEnum.zone) {
            this.fireUserDataElementPushTask(address, merge, subscribers, subscriber, taskListenerManager);
        } else {
            this.fireUserDataElementMultiPushTask(address, merge, subscribers, subscriber, taskListenerManager);
        }
    }

    private void fireUserDataElementPushTask(InetSocketAddress address, Datum datum, Collection<Subscriber> subscribers, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        datum = DatumUtils.newDatumIfNull(datum, subscriber);
        TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskType.USER_DATA_ELEMENT_PUSH_TASK);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)new URL(address));
        int size = datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},subSize={}", new Object[]{taskEvent.getTaskType(), address, datum.getDataInfoId(), datum.getDataCenter(), size, subscribers.size()});
        taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void fireUserDataElementMultiPushTask(InetSocketAddress address, Datum datum, Collection<Subscriber> subscribers, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        datum = DatumUtils.newDatumIfNull(datum, subscriber);
        TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskType.USER_DATA_ELEMENT_MULTI_PUSH_TASK);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)new URL(address));
        int size = datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},subSize={}", new Object[]{taskEvent.getTaskType(), address, datum.getDataInfoId(), datum.getDataCenter(), size, subscribers.size()});
        taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void fireReceivedDataPushTaskCloud(Map<String, Datum> datumMap, List<String> subscriberRegisterIdList, Subscriber subscriber, TaskListenerManager taskListenerManager) {
        ReceivedData receivedData = datumMap != null && !datumMap.isEmpty() ? ReceivedDataConverter.getReceivedDataMulti(datumMap, subscriber.getScope(), subscriberRegisterIdList, subscriber) : ReceivedDataConverter.getReceivedDataMulti(subscriber.getDataId(), subscriber.getGroup(), subscriber.getInstanceId(), "DefaultDataCenter", subscriber.getScope(), subscriberRegisterIdList, subscriber.getCell());
        HashMap<ReceivedData, URL> parameter = new HashMap<ReceivedData, URL>();
        parameter.put(receivedData, subscriber.getSourceAddress());
        TaskEvent taskEvent = new TaskEvent(parameter, TaskEvent.TaskType.RECEIVED_DATA_MULTI_PUSH_TASK);
        taskLogger.info("send {} taskURL:{},taskScope:{}", new Object[]{taskEvent.getTaskType(), subscriber.getSourceAddress(), subscriber.getScope()});
        taskListenerManager.sendTaskEvent(taskEvent);
    }
}

