/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.store;

import com.alipay.sofa.registry.common.model.store.Watcher;
import com.alipay.sofa.registry.common.model.store.WordCache;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.store.Watchers;
import com.alipay.sofa.registry.util.VersionsMapUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SessionWatchers
implements Watchers {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionWatchers.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private ConcurrentHashMap<String, Map<String, Watcher>> watchers = new ConcurrentHashMap();
    private Map<String, Map<String, Watcher>> connectIndex = new ConcurrentHashMap<String, Map<String, Watcher>>();
    private ConcurrentHashMap<String, Long> watcherVersions = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Watcher watcher) {
        Watcher.internWatcher((Watcher)watcher);
        this.write.lock();
        try {
            Watcher existingWatcher;
            HashMap<String, Watcher> watcherMap = this.watchers.get(watcher.getDataInfoId());
            if (watcherMap == null) {
                HashMap<String, Watcher> newMap = new HashMap<String, Watcher>();
                watcherMap = this.watchers.putIfAbsent(watcher.getDataInfoId(), newMap);
                if (watcherMap == null) {
                    watcherMap = newMap;
                }
            }
            if ((existingWatcher = watcherMap.get(watcher.getRegisterId())) != null) {
                LOGGER.warn("There is watcher already exists,it will be overwrite! {}", (Object)existingWatcher);
                this.invalidateConnectIndex(existingWatcher.getSourceAddress().getAddressString());
            }
            watcherMap.put(watcher.getRegisterId(), watcher);
            this.addConnectIndex(watcher);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteByConnectId(String connectId) {
        this.write.lock();
        try {
            for (Map<String, Watcher> map : this.watchers.values()) {
                Iterator<Watcher> it = map.values().iterator();
                while (it.hasNext()) {
                    Watcher watcher = it.next();
                    if (watcher == null || !connectId.equals(watcher.getSourceAddress().getAddressString())) continue;
                    it.remove();
                    this.invalidateConnectIndex(watcher.getSourceAddress().getAddressString());
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Delete watcher by connectId {} error!", (Object)connectId, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkWatcherVersions(String dataInfoId, Long version) {
        this.read.lock();
        try {
            Map<String, Watcher> watcherMap = this.watchers.get(dataInfoId);
            if (watcherMap == null || watcherMap.isEmpty()) {
                LOGGER.info("There are not Watcher Existed! Who are interest with dataInfoId {} !", (Object)dataInfoId);
                boolean bl = false;
                return bl;
            }
            boolean bl = VersionsMapUtils.checkAndUpdateVersions(this.watcherVersions, (String)dataInfoId, (Long)version);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Watcher> getWatchers(String dataInfoId) {
        this.read.lock();
        try {
            if (dataInfoId == null) {
                throw new IllegalArgumentException("Input dataInfoId can not be null!");
            }
            Map<String, Watcher> watcherMap = this.watchers.get(dataInfoId);
            if (watcherMap == null) {
                LOGGER.info("There is not registered Watcher for : {}", (Object)dataInfoId);
                Collection<Watcher> collection = null;
                return collection;
            }
            Collection<Watcher> collection = watcherMap.values();
            return collection;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteById(String registerId, String dataInfoId) {
        this.write.lock();
        try {
            Map<String, Watcher> watcherMap = this.watchers.get(dataInfoId);
            if (watcherMap == null) {
                LOGGER.error("Delete failed because watcher is not registered for dataInfoId: {}", (Object)dataInfoId);
                boolean bl = false;
                return bl;
            }
            Watcher watcher = watcherMap.remove(registerId);
            if (watcher == null) {
                LOGGER.error("Delete failed because watcher is not registered for registerId: {}", (Object)registerId);
                boolean bl = false;
                return bl;
            }
            this.removeConnectIndex(watcher);
            boolean bl = true;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Map<String, Watcher> queryByConnectId(String connectId) {
        this.read.lock();
        try {
            Map<String, Watcher> map = this.connectIndex.get(connectId);
            return map;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public long count() {
        AtomicLong count = new AtomicLong(0L);
        for (Map<String, Watcher> map : this.watchers.values()) {
            count.addAndGet(map.size());
        }
        return count.get();
    }

    private void addConnectIndex(Watcher watcher) {
        ConcurrentHashMap<String, Watcher> newSubscriberMap;
        String connectId = watcher.getSourceAddress().getAddressString();
        connectId = WordCache.getInstance().getWordCache(connectId);
        ConcurrentHashMap<String, Watcher> subscriberMap = this.connectIndex.get(connectId);
        if (subscriberMap == null && (subscriberMap = (ConcurrentHashMap<String, Watcher>)this.connectIndex.putIfAbsent(connectId, newSubscriberMap = new ConcurrentHashMap<String, Watcher>())) == null) {
            subscriberMap = newSubscriberMap;
        }
        subscriberMap.put(watcher.getRegisterId(), watcher);
    }

    private void removeConnectIndex(Watcher watcher) {
        String connectId = watcher.getSourceAddress().getAddressString();
        Map<String, Watcher> subscriberMap = this.connectIndex.get(connectId);
        if (subscriberMap != null) {
            subscriberMap.remove(watcher.getRegisterId());
        } else {
            LOGGER.warn("ConnectId {} not existed in Index to invalidate!", (Object)connectId);
        }
    }

    private void invalidateConnectIndex(String connectId) {
        this.connectIndex.remove(connectId);
    }
}

