/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.timertask;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.metrics.TaskMetrics;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.listener.ReceivedDataMultiPushTaskListener;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.store.DataStore;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.Watchers;
import com.alipay.sofa.registry.task.batcher.AcceptorExecutor;
import com.alipay.sofa.registry.task.batcher.TaskDispatcher;
import com.alipay.sofa.registry.task.batcher.TaskDispatchers;
import com.alipay.sofa.registry.task.listener.TaskListener;
import com.codahale.metrics.MetricRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class SyncClientsHeartbeatTask {
    private static final Logger CONSOLE_COUNT_LOGGER = LoggerFactory.getLogger((String)"SESSION-CONSOLE", (String)"[Count]");
    private static final Logger PRO_LOGGER = LoggerFactory.getLogger((String)"SESSION-PROFILE-DIGEST", (String)"[TaskExecute]");
    private static final Logger EXE_LOGGER = LoggerFactory.getLogger((String)"SESSION-PROFILE-DIGEST", (String)"[ExecutorMetrics]");
    public static final String SYMBOLIC1 = "  \u251c\u2500 ";
    public static final String SYMBOLIC2 = "  \u2514\u2500 ";
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private Watchers sessionWatchers;
    @Autowired
    private DataStore sessionDataStore;
    @Autowired
    private ExecutorManager executorManager;
    @Autowired
    private TaskListener receivedDataMultiPushTaskListener;

    @Scheduled(initialDelayString="${session.server.syncHeartbeat.fixedDelay}", fixedDelayString="${session.server.syncHeartbeat.fixedDelay}")
    public void syncCounte() {
        long countSub = this.sessionInterests.count();
        long countPub = this.sessionDataStore.count();
        long countSubW = this.sessionWatchers.count();
        int channelCount = 0;
        Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
        if (sessionServer != null) {
            channelCount = sessionServer.getChannelCount();
        }
        CONSOLE_COUNT_LOGGER.info("Subscriber count: {}, Publisher count: {}, Watcher count: {}, Connection count: {}", new Object[]{countSub, countPub, countSubW, channelCount});
    }

    @Scheduled(initialDelayString="${session.server.printTask.fixedDelay}", fixedDelayString="${session.server.printTask.fixedDelay}")
    public void printTaskExecute() {
        Map taskDispatcherMap = TaskDispatchers.getTaskDispatcherMap();
        if (taskDispatcherMap != null) {
            StringBuilder sb = new StringBuilder();
            this.logInfo(sb, taskDispatcherMap, "TaskDispatcher");
            PRO_LOGGER.info(sb.toString());
        }
    }

    protected void logInfo(StringBuilder sb0, Map<String, TaskDispatcher> taskDispatcherMap, String info) {
        sb0.append("\n").append(info).append(" >>>>>>>");
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, TaskDispatcher>> i = taskDispatcherMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, TaskDispatcher> entry = i.next();
            AcceptorExecutor acceptorExecutor = entry.getValue().getAcceptorExecutor();
            String outterTreeSymbol = SYMBOLIC1;
            if (!i.hasNext()) {
                outterTreeSymbol = SYMBOLIC2;
            }
            sb.append(outterTreeSymbol).append(entry.getKey());
            sb.append(", AcceptedTasks:").append(acceptorExecutor.getAcceptedTasks());
            sb.append(", ReplayedTasks:").append(acceptorExecutor.getReplayedTasks());
            sb.append(", QueueOverflows:").append(acceptorExecutor.getQueueOverflows());
            sb.append(" ,PendingTaskSize:").append(acceptorExecutor.getPendingTaskSize());
            sb.append(", ExpiredTasks:").append(acceptorExecutor.getExpiredTasks());
            sb.append(", OverriddenTasks:").append(acceptorExecutor.getOverriddenTasks());
            sb.append(", MaxBuffer:").append(acceptorExecutor.getMaxBufferSize()).append("\n");
        }
        sb0.append("\n").append((CharSequence)sb);
    }

    @Scheduled(initialDelayString="${session.server.printTask.fixedDelay}", fixedDelayString="${session.server.printTask.fixedDelay}")
    public void printExecutorTaskExecute() {
        Map<String, ThreadPoolExecutor> reportExecutors = this.executorManager.getReportExecutors();
        if (reportExecutors != null) {
            StringBuilder sb = new StringBuilder();
            this.logInfoExecutor(sb, reportExecutors, "ExecutorMetrics");
            EXE_LOGGER.info(sb.toString());
        }
    }

    protected void logInfoExecutor(StringBuilder sb0, Map<String, ThreadPoolExecutor> reportExecutors, String info) {
        sb0.append("\n").append(info).append(" >>>>>>>");
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, ThreadPoolExecutor>> i = reportExecutors.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ThreadPoolExecutor> entry = i.next();
            String executorName = entry.getKey();
            MetricRegistry metricRegistry = TaskMetrics.getInstance().getMetricRegistry();
            SortedMap map = metricRegistry.getGauges((name, value) -> name.startsWith(executorName));
            String outterTreeSymbol = SYMBOLIC1;
            if (!i.hasNext()) {
                outterTreeSymbol = SYMBOLIC2;
            }
            sb.append(outterTreeSymbol).append(executorName);
            map.forEach((key, gauge) -> {
                String name = key.substring(executorName.length() + 1);
                sb.append(", ").append(name).append(":").append(gauge.getValue());
            });
            sb.append("\n");
        }
        sb0.append("\n").append((CharSequence)sb);
    }

    @Scheduled(initialDelayString="${session.server.printTask.fixedDelay}", fixedDelayString="${session.server.printTask.fixedDelay}")
    public void printPushMultiTaskExecute() {
        if (this.receivedDataMultiPushTaskListener instanceof ReceivedDataMultiPushTaskListener) {
            ReceivedDataMultiPushTaskListener listener = (ReceivedDataMultiPushTaskListener)this.receivedDataMultiPushTaskListener;
            StringBuilder sb = new StringBuilder();
            sb.append("ReceivedDataPush").append(" >>>>>>>");
            sb.append(", AcceptedTasks:").append(listener.getTaskMergeProcessorStrategy().getPutTaskSize());
            sb.append(", SendTasks:").append(listener.getTaskMergeProcessorStrategy().getSendTaskSize());
            sb.append(" ,PendingTaskSize:").append(listener.getTaskMergeProcessorStrategy().getPendingTaskSize());
            sb.append(", OverriddenTasks:").append(listener.getTaskMergeProcessorStrategy().getOverrideTaskSize());
            sb.append("\n");
            PRO_LOGGER.info(sb.toString());
        }
    }
}

