/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.converter.ReceivedDataConverter;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import com.alipay.sofa.registry.util.DatumVersionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SubscriberPushEmptyTask
extends AbstractSessionTask {
    private static final Logger taskLogger = LoggerFactory.getLogger(SubscriberPushEmptyTask.class, (String)"[Task]");
    protected final SessionServerConfig sessionServerConfig;
    protected final TaskListenerManager taskListenerManager;
    protected Subscriber subscriber;

    public SubscriberPushEmptyTask(SessionServerConfig sessionServerConfig, TaskListenerManager taskListenerManager) {
        this.sessionServerConfig = sessionServerConfig;
        this.taskListenerManager = taskListenerManager;
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj;
        if (taskEvent.getTaskId() != null) {
            this.setTaskId(taskEvent.getTaskId());
        }
        if (!((obj = taskEvent.getEventObj()) instanceof Subscriber)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.subscriber = (Subscriber)obj;
    }

    public void execute() {
        this.executeTask();
    }

    protected void executeTask() {
        if (this.subscriber == null) {
            throw new IllegalArgumentException("Subscriber can not be null!");
        }
        List<String> subscriberRegisterIdList = Collections.singletonList(this.subscriber.getRegisterId());
        boolean isOldVersion = !BaseInfo.ClientVersion.StoreData.equals((Object)this.subscriber.getClientVersion());
        switch (this.subscriber.getScope()) {
            case zone: {
                if (isOldVersion) {
                    this.fireUserDataElementPushTask();
                    break;
                }
                this.fireReceivedDataPushTask(subscriberRegisterIdList, ScopeEnum.zone);
                break;
            }
            case dataCenter: {
                if (isOldVersion) {
                    this.fireUserDataElementMultiPushTask();
                    break;
                }
                this.fireReceivedDataPushTask(subscriberRegisterIdList, ScopeEnum.dataCenter);
                break;
            }
            case global: {
                this.fireReceivedDataPushTask(subscriberRegisterIdList, ScopeEnum.global);
                break;
            }
        }
    }

    protected void fireReceivedDataPushTask(List<String> subscriberRegisterIdList, ScopeEnum scopeEnum) {
        ReceivedData receivedData = ReceivedDataConverter.getReceivedDataMulti(this.subscriber.getDataId(), this.subscriber.getGroup(), this.subscriber.getInstanceId(), "DefaultDataCenter", scopeEnum, subscriberRegisterIdList, this.subscriber.getCell());
        receivedData.setVersion(Long.valueOf(DatumVersionUtil.nextId()));
        this.firePush(receivedData);
    }

    protected void firePush(ReceivedData receivedData) {
        HashMap<ReceivedData, URL> parameter = new HashMap<ReceivedData, URL>();
        parameter.put(receivedData, this.subscriber.getSourceAddress());
        TaskEvent taskEvent = new TaskEvent(parameter, TaskEvent.TaskType.RECEIVED_DATA_MULTI_PUSH_TASK);
        taskLogger.info("send {} taskURL:{},taskScope", new Object[]{taskEvent.getTaskType(), this.subscriber.getSourceAddress(), receivedData.getScope()});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    protected void fireUserDataElementPushTask() {
        Datum datum = new Datum();
        datum.setDataId(this.subscriber.getDataId());
        datum.setInstanceId(this.subscriber.getInstanceId());
        datum.setGroup(this.subscriber.getGroup());
        datum.setVersion(DatumVersionUtil.nextId());
        datum.setPubMap(new HashMap());
        datum.setDataCenter("DefaultDataCenter");
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
        subscribers.add(this.subscriber);
        TaskEvent taskEvent = new TaskEvent((Object)this.subscriber, TaskEvent.TaskType.USER_DATA_ELEMENT_PUSH_TASK);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)this.subscriber.getSourceAddress());
        taskLogger.info("send {} taskURL:{}", (Object)taskEvent.getTaskType(), (Object)this.subscriber.getSourceAddress());
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    protected void fireUserDataElementMultiPushTask() {
        Datum datum = new Datum();
        datum.setDataId(this.subscriber.getDataId());
        datum.setInstanceId(this.subscriber.getInstanceId());
        datum.setGroup(this.subscriber.getGroup());
        datum.setVersion(DatumVersionUtil.nextId());
        datum.setPubMap(new HashMap());
        datum.setDataCenter("DefaultDataCenter");
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
        subscribers.add(this.subscriber);
        TaskEvent taskEvent = new TaskEvent((Object)this.subscriber, TaskEvent.TaskType.USER_DATA_ELEMENT_MULTI_PUSH_TASK);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)this.subscriber.getSourceAddress());
        taskLogger.info("send {} taskURL:{}", (Object)taskEvent.getTaskType(), (Object)this.subscriber.getSourceAddress());
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getSubscriberRegisterFetchRetryTimes());
    }

    public String toString() {
        return "SubscriberPushEmptyTask{taskId='" + this.getTaskId() + '\'' + ", subscriber=" + this.subscriber + ", expiryTime='" + this.getExpiryTime() + '\'' + '}';
    }
}

